/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketException;

class WinCEDatagramSocketImpl
extends PlainDatagramSocketImpl {
    private DatagramPacket peekPacket = null;
    private int bufLength = 0;

    WinCEDatagramSocketImpl() {
    }

    protected synchronized void create() throws SocketException {
        super.create();
        this.bufLength = (Integer)this.getOption(4098);
    }

    protected synchronized int peek(InetAddress inetAddress) throws IOException {
        if (this.peekPacket == null) {
            int n = this.bufLength;
            DatagramPacket datagramPacket = new DatagramPacket(new byte[n], n);
            this.receive(datagramPacket);
            this.peekPacket = datagramPacket;
        }
        inetAddress.address = this.peekPacket.getAddress().address;
        inetAddress.family = this.peekPacket.getAddress().family;
        return this.peekPacket.getPort();
    }

    protected synchronized int peekData(DatagramPacket datagramPacket) throws IOException {
        int n;
        if (this.peekPacket == null) {
            n = this.bufLength;
            DatagramPacket datagramPacket2 = new DatagramPacket(new byte[n], n);
            this.receive(datagramPacket2);
            this.peekPacket = datagramPacket2;
        }
        n = Math.min(datagramPacket.getLength(), this.peekPacket.getLength());
        System.arraycopy(this.peekPacket.getData(), this.peekPacket.getOffset(), datagramPacket.getData(), datagramPacket.getOffset(), n);
        datagramPacket.setLength(n);
        datagramPacket.setAddress(this.peekPacket.getAddress());
        datagramPacket.setPort(this.peekPacket.getPort());
        return this.peekPacket.getPort();
    }

    protected synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        if (this.peekPacket == null) {
            super.receive(datagramPacket);
        } else {
            datagramPacket.setPort(this.peekPacket.getPort());
            datagramPacket.setAddress(this.peekPacket.getAddress());
            int n = Math.min(this.peekPacket.getLength(), datagramPacket.getLength());
            System.arraycopy(this.peekPacket.getData(), this.peekPacket.getOffset(), datagramPacket.getData(), datagramPacket.getOffset(), n);
            datagramPacket.setLength(n);
            this.peekPacket = null;
        }
    }

    public void setOption(int n, Object object) throws SocketException {
        super.setOption(n, object);
        if (n == 4098) {
            this.bufLength = (Integer)this.getOption(4098);
        }
    }
}

