/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.InstanceAttribute;
import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.InvalidArgumentCombination;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.Options;
import sun.misc.BASE64Encoder;

public class ModifyInstanceAttribute
extends BaseCmd {
    private static final String[] DISABLE_API_TERMINATION_DESC = new String[]{"Sets whether to disallow the termination of the instance", "using the API. Valid options are 'true' and 'false'."};
    private static final String[] BLOCK_DEVICE_MAPPING_DESC = new String[]{"Modifies the block-device-mapping for the instance, in the form", "'<device>=<block-device>', where 'block-device' can be one of the", "following:", "", " - '[<volume-id>][:<delete-on-termination>]': indicates that an Amazon", "   EBS volume should be exposed at the specified device. The following", "   combinations are supported:", "", "    - '<volume-id>': the ID of Amazon EBS volume, which must be owned", "      by the caller.", "", "    - '<delete-on-termination>': indicates whether the Amazon EBS", "      volume should be deleted on instance termination. If not", "      specified, this will default to 'true' and the volume will be", "      deleted.", "", "   For example: '/dev/sdb=vol-7eb96d16", "                '/dev/sdc=vol-7eb96d16:false", "", "See the latest Developer's Guide for further information."};
    private static final String[] INSTANCE_TYPE_DESC = new String[]{"Sets the instance-type of the specified instance to ", "INSTANCETYPE."};
    private static final String[] KERNEL_DESC = new String[]{"Sets the ID of the kernel to be used by the instance", "to KERNEL."};
    private static final String[] RAMDISK_DESC = new String[]{"Sets the ID of the ramdisk to be used by the instance", "to RAMDISK."};
    private static final String[] INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_DESC = new String[]{"Sets the behavior of the instance for an instance initiated", "shutdown (i.e. 'shutdown -h now').", "", " - 'stop': indicates that the instance should move into the stopped", "    state and remain available to be restarted.", "", " - 'terminate': indicates that the instance should move into the", "    terminated state."};
    private static final String[] USER_DATA_DESC = new String[]{"Sets the user data associated with the instance", "to USERDATA."};
    private static final String[] SOURCE_DEST_CHECK_DESC = new String[]{"Sets whether to enable the source/dest check on traffic through this instance.", "Valid options are 'true' and 'false'."};
    private static final String[] GROUP_IDS_DESC = new String[]{"Replace the security groups for a VPC instance."};
    private static final String GROUP_IDS_ARG = "GROUP_ID [ --group-id GROUP_ID [...]]";
    private static final Pattern BLOCK_DEVICE_MAPPING_PATTERN = Pattern.compile("(.*?)=(((.*?)){0,2})|(ephemeral(\\d+))|(noDevice)");
    private static final int GROUP_BDM_DEVICE = 1;
    private static final int GROUP_BDM_EBS = 3;
    private static final int GROUP_BDM_EPHEMERAL = 6;
    private static final int GROUP_BDM_NO_DEVICE = 8;
    private static final String SRIOV_NET_SUPPORT_DESC = "Set SR-IOV networking support for the instance.";

    public ModifyInstanceAttribute(String[] args) {
        super("ec2minatt", new String[]{"ec2-modify-instance-attribute", "ec2miatt"});
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs("t", "instance-type", INSTANCE_TYPE_DESC, "INSTANCETYPE"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs("b", "block-device-mapping", BLOCK_DEVICE_MAPPING_DESC, "MAPPING"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs(null, "disable-api-termination", DISABLE_API_TERMINATION_DESC, "BOOLEAN"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs(null, "kernel", KERNEL_DESC, "KERNEL"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs(null, "ramdisk", RAMDISK_DESC, "RAMDISK"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs(null, "instance-initiated-shutdown-behavior", INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_DESC, "BEHAVIOR"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs(null, "user-data", USER_DATA_DESC, "USERDATA"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs(null, "source-dest-check", SOURCE_DEST_CHECK_DESC, "BOOLEAN"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs("g", "group-id", GROUP_IDS_DESC, GROUP_IDS_ARG));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs(null, "ebs-optimized", EBS_OPTIMIZED_DESC, "BOOLEAN"));
        result.addOption(ModifyInstanceAttribute.createOptionWithArgs(null, "sriov", SRIOV_NET_SUPPORT_DESC, "SRIOV"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "[SPECIFIC OPTIONS] INSTANCE";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("block-device-mapping");
        this.printOption("instance-type");
        this.printOption("disable-api-termination");
        this.printOption("instance-initiated-shutdown-behavior");
        this.printOption("kernel");
        this.printOption("ramdisk");
        this.printOption("user-data");
        this.printOption("source-dest-check");
        this.printOption("group-id");
        this.printOption("ebs-optimized");
        this.printOption("sriov");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Modifies an instance attribute. Only one attribute can be specified per");
        System.out.println("     call.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        InstanceAttribute<?> instanceAttribute;
        String instanceId = this.getInstanceId();
        RequestResultPair rsp = jec2.modifyInstanceAttribute(instanceId, instanceAttribute = this.getInstanceAttribute());
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.outputInstanceAttribute(System.out, instanceId, instanceAttribute);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    private InstanceAttribute<?> getInstanceAttribute() {
        ArrayList attributes = new ArrayList(1);
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getBooleanAttribute(InstanceAttribute.InstanceAttributeType.disableApiTermination, "disable-api-termination"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getBlockDeviceMappingAttribute());
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getStringAttribute(InstanceAttribute.InstanceAttributeType.instanceType, "instance-type"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getStringAttribute(InstanceAttribute.InstanceAttributeType.kernel, "kernel"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getStringAttribute(InstanceAttribute.InstanceAttributeType.ramdisk, "ramdisk"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getStringAttribute(InstanceAttribute.InstanceAttributeType.instanceInitiatedShutdownBehavior, "instance-initiated-shutdown-behavior"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getUserDataAttribute(InstanceAttribute.InstanceAttributeType.userData, "user-data"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getBooleanAttribute(InstanceAttribute.InstanceAttributeType.sourceDestCheck, "source-dest-check"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getGroupMembershipAttribute(InstanceAttribute.InstanceAttributeType.groupSet, "group-id"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getBooleanAttribute(InstanceAttribute.InstanceAttributeType.ebsOptimized, "ebs-optimized"));
        ModifyInstanceAttribute.addIfNotNull(attributes, this.getStringAttribute(InstanceAttribute.InstanceAttributeType.sriovNetSupport, "sriov"));
        if (attributes.isEmpty()) {
            throw new InvalidArgumentCombination("An attribute must be specified.");
        }
        if (attributes.size() > 1) {
            throw new InvalidArgumentCombination("Only one attribute may be specified.");
        }
        return (InstanceAttribute)attributes.get(0);
    }

    private static <T> void addIfNotNull(List<T> list, T item) {
        if (item != null) {
            list.add(item);
        }
    }

    private InstanceAttribute<String[]> getGroupMembershipAttribute(InstanceAttribute.InstanceAttributeType type, String param) {
        String[] values = this.getOptionValues(param);
        if (values.length == 0) {
            return null;
        }
        return new InstanceAttribute(type, (Object)values);
    }

    private InstanceAttribute<String> getStringAttribute(InstanceAttribute.InstanceAttributeType type, String param) {
        String value = this.getOptionValue(param);
        if (value == null) {
            return null;
        }
        return new InstanceAttribute(type, (Object)value);
    }

    private InstanceAttribute<String> getUserDataAttribute(InstanceAttribute.InstanceAttributeType type, String param) {
        if (!this.isOptionSet(param)) {
            return null;
        }
        String value = this.getUserData(this.getOptionValue(param));
        if (value == null) {
            return null;
        }
        return new InstanceAttribute(type, (Object)value);
    }

    private InstanceAttribute<Boolean> getBooleanAttribute(InstanceAttribute.InstanceAttributeType type, String param) {
        String value = this.getOptionValue(param);
        if (value == null) {
            return null;
        }
        if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
            throw new GeneralError("The argument for --" + param + " must be 'true' or 'false', " + "but was '" + value + "'");
        }
        return new InstanceAttribute(type, (Object)Boolean.parseBoolean(value.toLowerCase()));
    }

    private InstanceAttribute<List<InstanceBlockDeviceMappingDescription>> getBlockDeviceMappingAttribute() {
        String[] bdmOptions = this.getOptionValues("block-device-mapping");
        if (bdmOptions == null || bdmOptions.length == 0) {
            return null;
        }
        List<InstanceBlockDeviceMappingDescription> blockDeviceMapping = this.getBlockDeviceMapping(this.getOptionValues("block-device-mapping"));
        return new InstanceAttribute(InstanceAttribute.InstanceAttributeType.blockDeviceMapping, blockDeviceMapping);
    }

    private List<InstanceBlockDeviceMappingDescription> getBlockDeviceMapping(String[] blockDeviceOptions) {
        ArrayList<InstanceBlockDeviceMappingDescription> blockDevices = new ArrayList<InstanceBlockDeviceMappingDescription>();
        if (blockDeviceOptions == null || blockDeviceOptions.length == 0) {
            return blockDevices;
        }
        for (String blockDeviceOption : blockDeviceOptions) {
            try {
                blockDevices.add(InstanceBlockDeviceMappingDescription.valueOf((String)blockDeviceOption));
            }
            catch (Exception e) {
                throw new InvalidArgument("block-device-mapping", blockDeviceOption);
            }
        }
        return blockDevices;
    }

    protected String getInstanceId() {
        String[] instanceIds = this.getNonOptions();
        if (instanceIds.length == 0) {
            throw new InvalidArgumentCombination("An instance ID must be specified.");
        }
        if (instanceIds.length > 1) {
            throw new InvalidArgumentCombination("Only one instance ID may be specified.");
        }
        return instanceIds[0];
    }

    private String getUserData(String str) {
        String base64 = new BASE64Encoder().encodeBuffer(str.getBytes());
        return base64.replaceAll("\\s", "");
    }

    public static void main(String[] args) {
        new ModifyInstanceAttribute(args).invoke();
    }
}

