#include "hdf.h"

main( )
{
	int32	file_id;
	int32	vgroup_id, vgroup_ref;
	int32	vdata_tag, vdata_ref;
	int32	status, i, npairs;

	/* Open the "Example2.hdf" file. */
	file_id = Hopen("Example2.hdf", DFACC_READ, 0);

	/* Initialize HDF for subsequent vgroup/vdata access. */
	status = Vstart(file_id);

	/* 	Attach to every vgroup in the file. */
	vgroup_ref = -1;

	while (TRUE) {
	   vgroup_ref = Vgetid(file_id, vgroup_ref);
	   if (vgroup_ref == -1) break;
	   vgroup_id = Vattach(file_id, vgroup_ref, "r"); 

	   /* Get the total number of tag/reference id pairs. */
	   npairs = Vntagrefs(vgroup_id);

	   /* Print every tag and reference id with their 
	   		corresponding file position. */
	   for (i = 0; i < npairs; i++) {
	      status = Vgettagref(vgroup_id, i, &vdata_tag, &vdata_ref);
	      printf("Found tag = %d, ref = %d at position %d.\n", \
	              vdata_tag, vdata_ref, i+1);
	   }

	   /* Terminate access to the vgroup. */
	   status = Vdetach(vgroup_id);
	}

	/* Terminate access to the V interface and close the file. */
	status = Vend(file_id);
	status = Hclose(file_id);

}
