      PROGRAM CREATE QUERY ATTRS

      integer file_id, vgroup_ref, vgroup_id, status
      integer vg_version
      integer hopen, vfstart, vfind, vfatch, vfdtch, hclose
      integer vfend, vsgver, vfgcatt, vfainfo, vfscatt
      integer v_type, v_count, v_size
      character*20 vgattrname, vgattr_buf
      character* (*) filename, vgattr_name, vg_attr
      parameter (filename = 'Example1.hdf',
     +   vgattr_name = 'Vgroup Attribute 1',
     +   vg_attr = 'mnpst'
     +    ) 

C     The following parameters are defined in hdf.inc.
      integer DFACC_RDWR, DFNT_CHAR
      parameter (DFACC_RDWR = 3, DFNT_CHAR = 4)

C     Open an HDF file with full access. 
      file_id = hopen(filename, DFACC_RDWR, 0)

C     Initialize the V interface. 
      status = vfstart(file_id)

C     Get the reference number of the target vgroup. 
      vgroup_ref = vfind(file_id, 'VG_Name_1')

C     Attach to the target vdata. 
      vgroup_id = vfatch(file_id, vgroup_ref, 'w')

C     Get the version of the vgroup just created. 
      vg_version = vsgver(vgroup_id)

C     Attach an attribute to the vgroup. 
      status = vfscatt(vgroup_id, vgattr_name, DFNT_CHAR, 5, vg_attr)

C     Get information about the vgroup attribute. 
      status = vfainfo(vgroup_id, 0, vgattrname, v_type, v_count,
     +                 v_size)

C     Get the vgroup attribute. 
      status = vfgcatt(vgroup_id, 0, vgattr_buf)

C     Detach from the vgroup, close the V interface and the file.
      status = vfdtch(vgroup_id)
      status = vfend(file_id)
      status = hclose(file_id)

      end
