      PROGRAM PRINT REFS

      integer*4 file_id, ref_array(31)
      integer vgroup_ref, vgroup_id, status
      integer n_entries, i
      character vgroup_name(64)
      logical loop_flag
      integer hopen, vflone, vfgid, vfatch, vfdtch
      integer vfinq, hclose, vfstart, vfend
      integer*4 DFACC_READ
      parameter (DFACC_READ = 1)

C     Open an HDF file with read access. 
C     DFACC_READ is defined in hdf.inc.
      file_id = hopen('Example2.hdf', DFACC_READ, 0)    

C     Initialize HDF for subsequent vgroup/vdata access. 
      status = vfstart(file_id)

C     Get and print the reference numbers of all the lone 
C     vgroups. 
      status = vflone(file_id, ref_array, 30)
      do 10 i = 1, status
         print *, 'Lone vgroup reference id ', ref_array(i)
10    continue   

      print *, '*******'

C     Set the reference number variable to start the search
C     at the first vgroup in the file.
      vgroup_ref = -1

C     Print every reference id in the file.  
      loop_flag = .TRUE.
      if (loop_flag) then
20       vgroup_ref = vfgid(file_id, vgroup_ref)
        if (vgroup_ref .eq. -1) then 
          go to 30
        end if
        vgroup_id = vfatch(file_id, vgroup_ref, 'r')
        status = vfinq(vgroup_id, n_entries, vgroup_name)
        print *, 'Found vgroup with ref ', vgroup_ref, 
     +           ' number of entries ', n_entries, 
     +           ' name ', vgroup_name
        status = vfdtch(vgroup_id)
        goto 20
      end if 

C     Terminate access to the V interface and the file. 
30    status = vfend(file_id)
      status = hclose(file_id)

      end
