      PROGRAM VDATA INSERT

      integer*4 file_id, vgroup_id, vdata_id, status, num_of_elements
      integer*4 vg_position
      integer*4 mesh(20, 3)
      double precision pxy(30, 2), temp(30)
      integer i, j
      integer hopen, vfatch, vfsnam, vsfatch 
      integer vsfsfld, vsfwrit, vsfdtch, vsffdef, vfdtch 
      integer hclose, vfinsrt, vfstart, vfend, vsfscls, vsfsnam
      data    pxy / -1.5, 2.3, -1.5, 1.98, -2.4, .67,
     +              -3.4, 1.46, -.65, 3.1, -.62, 1.23,
     +             -.4, 3.8, -3.55, 2.3, -1.43, 2.44,
     +             .23, 1.13, -1.4, 5.43, -1.4, 5.8,
     +             -3.4, 3.85, -.55, .3, -.21, 1.22,
     +             -1.44, 1.9, -1.4, 2.8, .94, 1.78,
     +             -.4, 2.32, -.87, 1.99, -.54, 4.11,
     +             -1.5, 1.35, -1.4, 2.21, -.22, 1.8,
     +             -1.1, 4.55, -.44, .54, -1.11, 3.93,
     +             -.76, 1.9, -2.34, 1.7, -2.2, 1.21 /

      integer*4 DFACC_CREAT
      parameter (DFACC_CREAT = 4)

C     Open an HDF file with full access. 
C      DFACC_CREAT is defined in hdf.inc.
      file_id = hopen('Example2.hdf', DFACC_CREAT, 0)

C     Create a vgroup with write access, then name it 'Vertices'. 
      status = vfstart(file_id)

C     Initialize the data buffer arrays. 
      do 10 i = 1, 30
        temp(i) = i * 10.0
10    continue

      do 20 i = 1, 20
        do 30 j = 1, 3
          mesh(i, j) = k
             k = k + 1
30      continue
20    continue
      vgroup_id = vfatch(file_id, -1, 'w')
      status = vfsnam(vgroup_id, 'Vertices')

C     Create a vdata to store the x,y values.  The number
C     '5' in the third argument of vsffdef corresponds to 
C     DFNT_FLOAT32 in hdf.inc.
      vdata_id = vsfatch(file_id, -1, 'w')
      status = vsfsnam(vdata_id, 'PX,PY')
      status =  vsfscls(vdata_id, 'Node List')
      status = vsffdef(vdata_id, 'PX', 5, 1)
      status = vsffdef(vdata_id, 'PY', 5, 1)
      status = vsfsfld(vdata_id, 'PX,PY')
      num_of_elements = vsfwrit(vdata_id, pxy, 30, FULL_INTERLACE)
      vg_position = vfinsrt(vgroup_id, vdata_id)
      status = vsfdtch(vdata_id)

C     Create a vdata to store the temperature data.  The number
C     '5' in the third argument corresponds to DFNT_FLOAT32
C     in hdf.inc.
      vdata_id = vsfatch(file_id, -1, 'w')
      status = vsfsnam(vdata_id, 'TMP')
      status =  vsfscls(vdata_id, 'Property List')
      status = vsffdef(vdata_id, 'TMP', 5, 1)
      status = vsfsfld(vdata_id, 'TMP')
      num_of_elements = vsfwrit(vdata_id, temp, 30, FULL_INTERLACE)
      vg_position = vfinsrt(vgroup_id, vdata_id)
      status = vsfdtch(vdata_id)

C     Create a vdata to store the mesh. The number '24' in the 
C     third argument of vsffdef corresponds to DFNT_INT32 in 
C     hdf.inc.
      vdata_id = vsfatch(file_id, -1, 'w')
      status = vsfsnam(vdata_id, 'PLIST')
      status = vsfscls(vdata_id, 'Connectivity List')
      status = vsffdef(vdata_id, 'PLIST', 24, 3)
      status = vsfsfld(vdata_id, 'PLIST')
      num_of_elements = vsfwrit(vdata_id, mesh, 20, FULL_INTERLACE)
      vg_position = vfinsrt(vgroup_id, vdata_id)
      status = vsfdtch(vdata_id)

C     Terminate access to the vgroup and the file. 
      status = vfdtch(vgroup_id)
      status =  vfend(file_id)

C     Close the HDF file. 
      status = hclose(file_id)

      end
