#include "hdf.h"

main( )
{

	int32	file_id, vgroup_id, vdata_id, status;
    int32	num_of_elements, vg_position;
	float32	pxy[30][2] = {-1.5, 2.3, -1.5, 1.98, -2.4, .67,
						-3.4, 1.46, -.65, 3.1, -.62, 1.23,
						-.4, 3.8, -3.55, 2.3, -1.43, 2.44,
						.23, 1.13, -1.4, 5.43, -1.4, 5.8,
						-3.4, 3.85, -.55, .3, -.21, 1.22,
						-1.44, 1.9, -1.4, 2.8, .94, 1.78,
						-.4, 2.32, -.87, 1.99, -.54, 4.11,
						-1.5, 1.35, -1.4, 2.21, -.22, 1.8,
						-1.1, 4.55, -.44, .54, -1.11, 3.93,
						-.76, 1.9, -2.34, 1.7, -2.2, 1.21};

    float32	temp[30]; 
	uint8	mesh[20][3];
	uint8	i, j, k = 0;	

	/* Open an HDF file with full access. */
	file_id = Hopen("Example2.hdf", DFACC_CREATE, 0);

	/* Initialize HDF for subsequent vgroup/vdata access. */
	status = Vstart(file_id);

	/* Initialize the data buffer arrays. */
	for (i = 0; i < 30; i++)
	   temp[i] = i * 10.0;

	for (i = 0; i < 20; i++) {
	   for (j = 0; j < 3; j++) {
	      mesh[i][j] = ++k;
	   }
	}

	/* Create a vgroup with write access, then name it "Vertices". */
	vgroup_id = Vattach(file_id, -1, "w");
	status = Vsetname(vgroup_id, "Vertices");

	/* Create a vdata to store the x,y values, set its name and class. */
	vdata_id = VSattach(file_id, -1, "w");
	status = VSsetname(vdata_id, "PX and PY");
	status = VSsetclass(vdata_id, "Node List");

	/* Specify the PX field information. */
	status = VSfdefine(vdata_id, "PX", DFNT_FLOAT32, 2);

	/* Specify the PY field information. */
	status = VSfdefine(vdata_id, "PY", DFNT_FLOAT32, 2);

	/* Set the field names. */
	status = VSsetfields(vdata_id, "PX,PY");

	/* Write the buffered data into the vdata object. */
	num_of_elements = VSwrite(vdata_id, (VOIDP)pxy, 30, FULL_INTERLACE);

	/* Insert the vdata into the vgroup. */
	vg_position = Vinsert(vgroup_id, vdata_id);

	/* Detach from the vdata. */
	status = VSdetach(vdata_id);

	/* Create a vdata to store the temperature property data. */
	vdata_id = VSattach(file_id, -1, "w");
	status = VSsetname(vdata_id, "PLIST");
	status = VSsetclass(vdata_id, "Connectivity List");
	status = VSfdefine(vdata_id, "PLIST", DFNT_FLOAT32, 1);
	status = VSsetfields(vdata_id, "PLIST");
	num_of_elements = VSwrite(vdata_id, (VOIDP)temp, 30, FULL_INTERLACE);
	vg_position = Vinsert(vgroup_id, vdata_id);
	status = VSdetach(vdata_id);

	/* Create a vdata to store the mesh. */
	vdata_id = VSattach(file_id, -1, "w");
	status = VSsetname(vdata_id, "TMP");
	status = VSsetclass(vdata_id, "Property List");
	status = VSfdefine(vdata_id, "TMP", DFNT_INT8, 3);
	status = VSsetfields(vdata_id, "TMP");
	num_of_elements = VSwrite(vdata_id, (VOIDP)mesh, 20, FULL_INTERLACE);
	vg_position = Vinsert(vgroup_id, vdata_id);
	status = VSdetach(vdata_id);

	/* Terminate access to the "Vertices" vgroup. */
	status = Vdetach(vgroup_id);

	/* Terminate access to the V interface. */
	status = Vend(file_id);

	/* Close the HDF file. */
	status = Hclose(file_id);

}
