      PROGRAM DATA READ

      character vdata_name*30, vdata_class*30, fields*60
      character databuf*40
      integer file_id, vdata_ref, vdata_id
      integer*4 n_records, interlace, vdata_size
      integer status
      integer hopen, vsfgid, vsfatch, vsfinq, vsfgcls
      integer vsfsfld, vsfread, vsfdtch, hclose, vfstart, vfend

C     DFACC_RDONLY and FULL_INTERLACE are defined in hdf.inc.
      integer*4 DFACC_RDONLY, FULL_INTERLACE
      parameter (DFACC_RDONLY = 1,
     +           FULL_INTERLACE = 0)

C     Open an HDF file with read-only access. 
      file_id = hopen('Example4.hdf', DFACC_RDONLY, 0)

C     Initialize the Vset interface. 
      status = vfstart(file_id)

C     Get the reference number for the first Vdata in 
C     the file. 
      vdata_ref = -1
      vdata_ref = vsfgid(file_id, vdata_ref)

C     Attach to the first Vdata in read mode. 
      vdata_id = vsfatch(file_id, vdata_ref, 'r')

C     Get the list of field names. 
      status = vsfinq(vdata_id, n_records, interlace, fields, 
     +               vdata_size, vdata_name)

C     Get the class. 
      status = vsfgcls(vdata_id, vdata_class)

C     Determine the fields that will be read. 
      status = vsfsfld(vdata_id, fields)
      
C     Print the Vdata information. 
      print *, 'Current Vdata name: ', vdata_name
      print *, 'Current Vdata class: ', vdata_class

C     Read the data. 
      status = vsfread(vdata_id, databuf, n_records, FULL_INTERLACE)

C     Detach from the Vdata, close the Vset interface and the file. 
      status = vsfdtch(vdata_id)
      status = vfend(file_id)
      status = hclose(file_id)

      end
