#include "hdf.h"
#define NRECORDS 20

main( )
{

	char 	vdata_name[MAX_NC_NAME], vdata_class[MAX_NC_NAME], fields[60];
	int32	file_id, vdata_id, status, num_of_elements;
	int32 	n_records, interlace, vdata_size, vdata_ref;
	uint8 	databuf[((2 * sizeof(float32)) + sizeof(char) \
					+ sizeof(int16)) * NRECORDS];

	/* Open the HDF file. */
	file_id = Hopen("Example4.hdf", DFACC_RDONLY, 0);

	/* Initialize the Vset interface. */
	status = Vstart(file_id);

	/* 
	* Get the reference number for the first vdata in 
	* the file. 
	*/
	vdata_ref = -1;
	vdata_ref = VSgetid(file_id, vdata_ref);

	/* Attach to the first vdata in read mode. */
	vdata_id = VSattach(file_id, vdata_ref, "r");

	/* Get the list of field names. */
	status = VSinquire(vdata_id, &n_records, &interlace, fields, &vdata_size, \
                        vdata_name);

	/* Get the class. */
	status = VSgetclass(vdata_id, vdata_class);

	/* Determine the fields that will be read. */
	status = VSsetfields(vdata_id, fields);
	
	/* Print the vdata information. */
	printf("Current vdata name: %s \nCurrent vdata class: %s\n", \
                     vdata_name, vdata_class);

	/* Read the data. */
	num_of_elements = VSread(vdata_id, databuf, n_records, FULL_INTERLACE);

	/* Detach from the vdata, close the vset interface and the file. */
	status = VSdetach(vdata_id);
	status = Vend(file_id);
	status = Hclose(file_id);

}
