#include "hdf.h"

#define FILE_NAME "Example1.hdf"
#define VGATTR_NAME "Vgroup Attribute 1"

main( )
{

	int32	 file_id, vgroup_ref, vgroup_id, status;
	int32	 vg_version;
	int32	 v_type, v_count, v_size;
	char	 vg_attr[6] = {'m','N','p', 'S', 't', '\0'};
	char	 vgattr_buf[6], vattrname[30];

	/* Open the HDF file. */
	file_id = Hopen(FILE_NAME, DFACC_RDWR, 0);

	/* Initialize the V interface. */
	status = Vstart(file_id);

    /* Get the reference number of the target vgroup. */
    vgroup_ref = Vfind(file_id, "VG_Name_1");

    /* Attach to the target vgroup. */
    vgroup_id = Vattach(file_id, vgroup_ref, "w");

    /* Get the version of the vgroup just created. */
    vg_version = Vgetversion(vgroup_id);

    /* Attach an attribute to the vgroup. */
    status = Vsetattr(vgroup_id, VGATTR_NAME, DFNT_CHAR, 6, vg_attr);

    /* Get information about the vgroup attribute. */
    status = Vattrinfo(vgroup_id, 0, vattrname, &v_type, &v_count, &v_size);

    /* Get the vgroup attribute. */
    status = Vgetattr(vgroup_id, 0, vgattr_buf);

	/* Detach from the vgroup, close the V interface and the file. */
	status = Vdetach(vgroup_id);
	status = Vend(file_id);
	status = Hclose(file_id);

}

