#include "hdf.h"

main( )
{

	int32	file_id, status;
	int32	vgroup_ref, vgroup_id;
	int32	maxsize, i, num_of_lones;
	int32	n_entries, *ref_array; 
	char	vgroup_name[VGNAMELENMAX];

	/* 	Open the "Example2.hdf" file. */
	file_id = Hopen("Example2.hdf", DFACC_READ, 0); 

	/* 	Initialize HDF for subsequent vgroup/vdata access. */
	status = Vstart(file_id);

    /*	Get and print the reference numbers of all the lone 
	 	vgroups.  First, call Vlone with maxsize set to 0 to 
		get the length of the storage array, then call Vlone 
	 	again to put the reference id numbers into the array. 	*/
	maxsize = Vlone(file_id, ref_array, 0);
	ref_array = (int32 *) HDmalloc(sizeof(int32) * maxsize);
	num_of_lones = Vlone(file_id, ref_array, maxsize);

	for (i = 0; i < maxsize; i++)
	   printf("Lone vgroup reference id  %d\n", ref_array[i]); 

	printf("*******\n");
    HDfree(ref_array);

    /*	Set the reference number variable to start the search
		at the first vgroup in the file.	*/ 
	vgroup_ref = -1;

	/* 	Print every reference id in the file. */ 
	while (TRUE) {
	   vgroup_ref = Vgetid(file_id, vgroup_ref);
	   if (vgroup_ref == -1) break; 
	   vgroup_id = Vattach(file_id, vgroup_ref, "r");
	   status = Vinquire(vgroup_id, &n_entries, vgroup_name);
       printf("Found vgroup with ref %d, number of entries %d, name %s\n", 
              vgroup_ref, n_entries, vgroup_name); 
       Vdetach(vgroup_id);
	} 

	/* Terminate access to the vgroup interface and the file. */
	status = Vend(file_id);
	status = Hclose(file_id);

}
