#include "hdf.h"

#define FILE_NAME "Example3.hdf"

main( )
{

	int32	 file_id, vdata_ref, vdata_id, status;
	int32	 n_records, interlace, vdata_size;
	char	 fields[30], vdata_name[VSNAMELENMAX];
	int8 	found_fields;

	/* Open the HDF file. */
	file_id = Hopen(FILE_NAME, DFACC_RDONLY, 0);

	/* Initialize the vdata interface. */
	status = Vstart(file_id);

	vdata_ref = -1;
	found_fields = 0;

	/* Attach to each vdata and search for the fields. */ 
	while ((vdata_ref = VSgetid(file_id, vdata_ref)) != -1) {
	   vdata_id = VSattach(file_id, vdata_ref, "r");
	   	status = VSinquire(vdata_id, &n_records, &interlace, fields, 
                           &vdata_size, vdata_name);
		status = VSdetach(vdata_id);
	   if (!strncmp(vdata_name, "Example Vdata", 20)) {
	      found_fields = 1;
	      break;
	   } else VSdetach(vdata_id);
	}

	if (!found_fields) 
	   printf("Vdata name - Example Vdata - was not found.\n");
	else 
	   printf("Vdata name - Example Vdata - found, vdata id %d.\n", 
                         vdata_ref);

	/* Detach from the vdata, close the VS interface and the file. */
	status = VSdetach(vdata_id);
	status = Vend(file_id);
	status = Hclose(file_id);

}
