      PROGRAM CREATE QUERY ATTRS

      integer file_id, vdata_ref, vdata_id, status
      integer n_fldattrs, n_vdattrs
      integer hopen, vfstart, vsffnd, vsfatch, vsfdtch, hclose
      integer vfend, vsfscat, vsfsnat, vsffnas, vsfnats
      integer vsfainf, vsfgnat, vsfgcat
      integer v_type, v_count, v_size, f_type, f_count, f_size
      double precision fld_attr(2), fattr_buf(2)
      character*20 vattrname, vattr_buf
      character*50 filename, vd_attr, fattr_name
      parameter (filename = 'Example3.hdf',
     +      vattr_name = 'Vdata Attribute 1',
     +      vd_attr = 'mnpst',
     +      fattr_name = 'Field Attribute 1'
     +     	) 

C     The following parameters are defined in hdf.inc.
      integer DFACC_RDWR, DFNT_CHAR, DFNT_FLOAT32, _HDF_VDATA
      parameter (DFACC_RDWR = 3, DFNT_CHAR = 4, DFNT_FLOAT32 = 5,
     +           _HDF_VDATA = -1)

      fld_attr(1) = 30.452
      fld_attr(2) = 5.467

C     Open an HDF file with full access. 
      file_id = hopen(filename, DFACC_RDWR, 0)

C     Initialize the VS interface. 
      status = vfstart(file_id)

C     Get the reference number of the target vdata. 
      vdata_ref = vsffnd(file_id, 'Example Vdata')

C     Attach to the target vdata. 
      vdata_id = vsfatch(file_id, vdata_ref, 'w')

C     Attach an attribute to the vdata. 
      status = vsfscat(vdata_id, _HDF_VDATA, vattr_name, 
     +                 DFNT_CHAR, 5, vd_attr)

C     Attach an attribute to the first field of the vdata. 
      status = vsfsnat(vdata_id, _HDF_VDATA, fattr_name, 
     +                 DFNT_FLOAT32, 2, fld_attr)

C     Get the number of attributes attached to the first field. 
      n_fldattrs = vsffnas(vdata_id, 0)

C     Get the total number of field and vdata attributes. 
      n_vdattrs = vsfnats(vdata_id)

C     Get information about the vdata attribute. 
      status = vsfainf(vdata_id, _HDF_VDATA, 0, vattrname, 
     +               v_type, v_count, v_size)

C     Get information about the field attribute. 
      status = vsfainf(vdata_id, 0, 0, vattrname, f_type, 
     +               f_count, f_size)

C     Get the vdata attribute. 
      status = vsfgnat(vdata_id, _HDF_VDATA, 0, vattr_buf)

C     Get the field attribute. 
      status = vsfgcat(vdata_id, 0, 0, fattr_buf)

C     Detach from the vdata, close the VS interface and the file.
      status = vsfdtch(vdata_id)
      status = vfend(file_id)
      status = hclose(file_id)

      end
