#include "hdf.h"

#define FILE_NAME "Example4.hdf"

main( )
{

	int32	 file_id, vdata_ref, vdata_id, status;
	int8	 found_fields;

	/* Open the HDF file. */
	file_id = Hopen(FILE_NAME, DFACC_RDONLY, 0);

	/* Initialize the vset interface. */
	status = Vstart(file_id);

	vdata_ref = -1;
	found_fields = 0;

	/* Attach to each vdata and search for the fields. */ 
	while ((vdata_ref = VSgetid(file_id, vdata_ref)) != -1) {
	   vdata_id = VSattach(file_id, vdata_ref, "r");
	   if ((status = VSfexist(vdata_id, "Temp,Speed,Height,Ident")) != FAIL) {
	      found_fields = 1;
	      break;
	   } else {
          status = VSdetach(vdata_id);
       }
	}

	if (!found_fields) printf("Fields TEMP and IDENT were not found.\n");
	else printf("Fields TEMP and IDENT found in vdata id %d\n", vdata_ref);

	/* Detach from the vdata, close the Vset interface and the file. */
	status = VSdetach(vdata_id);
	status = Vend(file_id);
	status = Hclose(file_id);

}
