#include "hdf.h"
#include "mfhdf.h"

#define X_LENGTH 4
#define Y_LENGTH 5
#define Z_LENGTH 6

main( )
{
    int32 sd_id, sds_id, status;
    int32 start[3], edges[3];
    int16 array_data[Z_LENGTH][Y_LENGTH][X_LENGTH];

    /* Open the file and initiate the SD interface. */
    sd_id = SDstart("Example4.hdf", DFACC_RDONLY);

    /* Select the first (and in this case, only) data set in the file. */
    sds_id = SDselect(sd_id, 0);

    /* Define the location, pattern, and size of the data to read. */
    start[0] = start[1] = start[2] = 0;
    edges[0] = Z_LENGTH;
    edges[1] = Y_LENGTH;
    edges[2] = X_LENGTH;

   	/* Read the array. */
    status = SDreaddata(sds_id, start, NULL, edges, (VOIDP)array_data);

   	/* Terminate access to the array */
    status = SDendaccess(sds_id);

  	/* Terminate access to the SD interface and close the file. */
    status = SDend(sd_id);
    
}
