#include "hdf.h"
#include "mfhdf.h"

	/* Arrays containing dimension info for datasets. */
	static int32  d_dims[3]     = {2, 3, 4};  /* Data dimensions */
	static int32  edge_dims[3]  = {0, 0, 0};  /* Edge dims */
	static int32  start_dims[3] = {0, 0, 0};  /* Starting dims  */
	static int32  cdims[3]      = {1, 2, 3};  /* Chunk lengths */

    int32 status;

	static uint16  u16_3data[2][3][4] =
    {
    {
        { 0, 1, 2, 3},
        { 10, 11, 12, 13},
        { 20, 21, 22, 23}},
    {
        { 100, 101, 102, 103},
        { 110, 111, 112, 113},
        { 120, 121, 122, 123}}};

main( ) 
{

	int32 f1;	/* File handle */
	int32 sdsid;	/* SDS handle */
	uint16  inbuf_3u16[2][3][4];	/* Data array read */
	uint16  fill_u16 = 0;        /* Fill value */
	int32 c_flags;

	HDF_CHUNK_DEF c_def, r_def; 

    /* Create the HDF file. */
	f1 = SDstart("Example14.hdf", DFACC_CREATE);

    /* Create a new 2x3x4 SDS of uint16 in the file. */
	d_dims[0] = 2;
	d_dims[1] = 3;
	d_dims[2] = 4;
	sdsid = SDcreate(f1, "DataSetChunked_2", DFNT_UINT16, 3, d_dims);

	/* Set the fill value. */
	fill_u16 = 0;
	status = SDsetfillvalue(sdsid, (VOIDP) &fill_u16);

	/* Create chunked SDS - chunk is 2x3x2 which will create 2 chunks */
	c_def.chunk_lengths[0] = 2;
	c_def.chunk_lengths[1] = 3;
	c_def.chunk_lengths[2] = 2;
	status = SDsetchunk(sdsid, c_def, HDF_CHUNK);

	/* Set chunk cache to hold a maximum of 2 chunks*/
	status = SDsetchunkcache(sdsid, 2, 0);

	/* Write data using SDwritedata. */
	start_dims[0] = 0;
	start_dims[1] = 0;
	start_dims[2] = 0;
	edge_dims[0] = 2;
	edge_dims[1] = 3;
	edge_dims[2] = 4;
	status = SDwritedata(sdsid, start_dims, NULL, edge_dims, \
					(VOIDP) u16_3data);

	/* Read data using SDreaddata. */
	start_dims[0] = 0;
	start_dims[1] = 0;
	start_dims[2] = 0;
	edge_dims[0] = 2;
	edge_dims[1] = 3;
	edge_dims[2] = 4;
	status = SDreaddata(sdsid, start_dims, NULL, edge_dims, \
						(VOIDP) inbuf_3u16);

	/* Verify the data in inbuf_3u16 against u16_3data[]. */

	/* Get chunk lengths. */
	status = SDgetchunkinfo(sdsid, &r_def, &c_flags);

	/* Close the current SDS. */    
	status = SDendaccess(sdsid);

	/* Close down SDS interface. */
	status = SDend(f1);

}

