#include "hdf.h"
#include "mfhdf.h"

	/* Arrays containing dimension info for datasets. */
	static int32  d_dims[3]     = {2, 3, 4};  /* Data dimensions */
	static int32  edge_dims[3]  = {0, 0, 0};  /* Edge dims */
	static int32  start_dims[3] = {0, 0, 0};  /* Starting dims  */
	static int32  cdims[3]      = {1, 2, 3};  /* Chunk lengths */

    int32 status;

    static uint16  chunk1_2u16[6] = {11, 21, 
                                     12, 22, 
                                     13, 23};
    
    static uint16  chunk2_2u16[6] = {31, 41, 
                                     32, 42, 
                                     33, 43};
    
    static uint16  chunk3_2u16[6] = {14, 24, 
                                     15, 25, 
                                     16, 26};
    
    static uint16  chunk4_2u16[6] = {34, 44, 
                                     35, 45, 
                                     36, 46};
    
    static uint16  chunk5_2u16[6] = {17, 27, 
                                     18, 28, 
                                     19, 29};
    
    static uint16  chunk6_2u16[6] = {37, 47, 
                                     38, 48, 
                                     39, 49};

main( ) 
{

	int32 f1;	/* File handle */
	int32 sdsid;	/* SDS handle */
	uint16  inbuf_2u16[5][2];    /* Data array read */
	uint16  fill_u16 = 0;        /* Fill value */
	int32 c_flags;

	HDF_CHUNK_DEF c_def, r_def; 

    /* Create the HDF file. */
	f1 = SDstart("Example13.hdf", DFACC_CREATE);

	/* Create a  9x4 SDS of uint16 in file 1. */
	d_dims[0] = 9;
	d_dims[1] = 4;

	sdsid = SDcreate(f1, "DataSetChunked_1", DFNT_UINT16, 2, d_dims);

	/* Set the fill value. */
	fill_u16 = 0;
	status = SDsetfillvalue(sdsid, (VOIDP) &fill_u16);

	/* Create chunked SDS chunk with 3x2 chunks which will create 
		6 chunks. */

	c_def.chunk_lengths[0] = 3;
	c_def.chunk_lengths[1] = 2;

	status = SDsetchunk(sdsid, c_def, HDF_CHUNK);

	/* Set chunk cache to hold a maximum of 3 chunks */
	status = SDsetchunkcache(sdsid, 3, 0);

	/* Write the data chunks. */

	/* Write chunk 1. */
	start_dims[0] = 0;
	start_dims[1] = 0;
	status = SDwritechunk(sdsid, start_dims, (VOIDP) chunk1_2u16);

	/* Write chunk 4. */
	start_dims[0] = 1;
	start_dims[1] = 1;
	status = SDwritechunk(sdsid, start_dims, (VOIDP) chunk4_2u16);

	/* Write chunk 2. */
	start_dims[0] = 0;
	start_dims[1] = 1;
	status = SDwritechunk(sdsid, start_dims, (VOIDP) chunk2_2u16);

	/* Write chunk 5. */
	start_dims[0] = 2;
	start_dims[1] = 0;
	status = SDwritechunk(sdsid, start_dims, (VOIDP) chunk5_2u16);

	/* Write chunk 3. */
	start_dims[0] = 1;
	start_dims[1] = 0;
	status = SDwritechunk(sdsid, start_dims, (VOIDP) chunk3_2u16);

	/* Write chunk 6. */
	start_dims[0] = 2;
	start_dims[1] = 1;
	status = SDwritechunk(sdsid, start_dims, (VOIDP) chunk6_2u16);

	/* Read a subset of the data back in using SDreaddata
       i.e  5x2 subset of the whole array. */
	start_dims[0] = 2;
	start_dims[1] = 1;
	edge_dims[0] = 5;
	edge_dims[1] = 2;
	status = SDreaddata(sdsid, start_dims, NULL, edge_dims, \
						(VOIDP) inbuf_2u16);

	/* This 5x2 array should look like this
         {{23, 24, 25, 26, 27},
          {33, 34, 35, 36, 37}} 		*/

	/* Get chunk lengths. */
	status = SDgetchunkinfo(sdsid, &r_def, &c_flags);

	/* Close the current SDS. */    
	status = SDendaccess(sdsid);

	/* Close down the SDS interface. */
	status = SDend(f1);

}

