#include "hdf.h"
#include "mfhdf.h"

#define X_LENGTH 10
#define Y_LENGTH 20

main( ) 
{

	int32 sd_id, sds_id, rank, start[2], edges[2], stride[2], dims[2];
	int16 all_data[Y_LENGTH][X_LENGTH], sample_data[5][5];
	intn i, j;
    int16 status;

	/* Open the file. */
	sd_id = SDstart("Example10.hdf", DFACC_CREATE);

	/* Define the rank and dimensions of the array to be created. */
	rank = 2;
	dims[0] = Y_LENGTH;
	dims[1] = X_LENGTH;

	/* 	Create the array. */
	sds_id = SDcreate(sd_id, "Ex_array_10", DFNT_INT16, rank, dims);

	/* 	Compute and store the data values. */
	for (j = 0; j < Y_LENGTH; j++) {
		for (i = 0; i < X_LENGTH; i++) 
			all_data[j][i] = i + j * 10;
    }

	/* 	Define the start and edge parameters. */
	start[0] = start[1] = 0;
	edges[0] = Y_LENGTH;
	edges[1] = X_LENGTH;

	/* 	Write the buffered data in all_data to the data set. */
	status = SDwritedata(sds_id, start, NULL, edges, (VOIDP)all_data);

	/* 	Close the SD interface and the file, then re-open both and \
		select the first and only data set in the file. */

	status = SDendaccess(sds_id);
	status = SDend(sd_id);

	sd_id = SDstart("Example10.hdf", DFACC_RDONLY);
	sds_id = SDselect(sd_id, 0);

	/* 	Read the data into the sample_data array, skipping every fourth \
		row and every other column. */
	start[0] = start[1] = 0;
	edges[0] = 5;
	edges[1] = 5;
	stride[0] = 4;
	stride[1] = 2;

	status = SDreaddata(sds_id, start, stride, edges, (VOIDP)sample_data);

	/* 	Terminate access to the array */
	status = SDendaccess(sds_id);

	/* 	Terminate access to the SD interface and close the file */
	status = SDend(sd_id);

}

