      PROGRAM SEARCH INDEX

      integer*4 gr_id, gr_index, ri_id, file_id, status
      integer*4 start(2), edges(2), stride(2) 
      integer mgstart, mgn2ndx, mgrdimg, mgendac, mgselct
      integer mgend, hopen, hclose

C     DFACC_RDONLY is defined in hdf.h.
      integer*4 DFACC_RDONLY
      integer*4 X_LENGTH, Y_LENGTH
      parameter (DFACC_RDONLY = 1, X_LENGTH = 10, Y_LENGTH = 20)
      integer*2 image_data(2, X_LENGTH, Y_LENGTH)

C     Open the file. 
      file_id = hopen('Example5.hdf', DFACC_RDONLY, 0)

C     Initialize the GR interface. 
      gr_id = mgstart(file_id)

C     Search for the index of a non-existent image. 
      gr_index = mgn2ndx(gr_id, 'Invalid_Data_Set_Name')

C     Error condition: gr_index contains the value -1. 
C     Search for the index of the image named 'Image_array_5'. 
      gr_index = mgn2ndx(gr_id, 'Image_array_5')

C     Select the image corresponding to the returned index.
      ri_id = mgselct(gr_id, gr_index)

C     Read the image data into the image_data array. 
      start(1) = 0
      start(2) = 0
      edges(1) = X_LENGTH
      edges(2) = Y_LENGTH
      stride(1) = 1
      stride(2) = 1
      status = mgrdimg(ri_id, start, stride, edges, image_data)

C     Terminate access to the array. 
      status = mgendac(ri_id)

C     Terminate access to the GR interface and the file.
      status = mgend(gr_id)

C     Close the file.
      status = hclose(file_id)

      end

