#include "hdf.h"
#include "mfgr.h"

#define X_LENGTH 15
#define Y_LENGTH 10

main( ) 
{
	int32 gr_id, ri_id, file_id, status, il;
	int32 nt, dimsizes[2], ncomp, nattrs;
	int32 start[2], edges[2];
	int16 image_data[Y_LENGTH][X_LENGTH][2];
	char name[MAX_GR_NAME];

	/* Open the file. */
	file_id = Hopen("Example2.hdf", DFACC_RDONLY, 0);

	/* Initiate the GR interface. */
	gr_id = GRstart(file_id);

	/* Select the first (and in this case, only) image in the file. */
	ri_id = GRselect(gr_id, 0);

	/* Verify the characteristics of the image. */
	status = GRgetiminfo(ri_id, name, &ncomp, &nt, &il, dimsizes, &nattrs);

	/* Define the location, pattern, and size of the data to read from \
		the image. */
	start[0] = start[1] = 0;
	edges[0] = dimsizes[0];
	edges[1] = dimsizes[1];

	/* Read the array data set created in Example 2. */
	status = GRreadimage(ri_id, start, NULL, edges, (VOIDP)image_data);

	/* Terminate access to the image. */
	status = GRendaccess(ri_id);

	/* Terminate access to the GR interface. */
	status = GRend(gr_id);

	/* Close the file. */
	status = Hclose(file_id);

}
