      PROGRAM READ STRIDES

      integer*4 gr_id, ri_id, file_id, ncomp, il
      integer*4 start(2), edges(2), stride(2), dims(2)
      integer i, j, status
      integer mgstart, mgcreat, mgwrimg, mgendac
      integer mgselct, mgend, hopen, hclose

C     DFACC_CREATE and DFNT_INT16 are defined in hdf.h.
      integer*4 DFACC_CREATE, DFACC_RDONLY, DFNT_INT16
      integer*4 X_LENGTH, Y_LENGTH

      parameter (DFACC_CREATE = 4, DFACC_RDONLY = 1, DFNT_INT16 = 22,
     +           X_LENGTH = 10, Y_LENGTH = 20)
      integer*2 all_image(2, X_LENGTH, Y_LENGTH)

C     Create the file.
      file_id = hopen('Example5.hdf', DFACC_CREATE, 0)

C     Create the file.
      gr_id = mgstart(file_id)

C     Define the number of components and dimensions of the image.
      ncomp = 2
      dims(1) = X_LENGTH
      dims(2) = Y_LENGTH

C     Create the array.
      ri_id = mgcreat(gr_id, 'Image_array_5', ncomp, DFNT_INT16, il,
     +           dims)

C     Compute and store the data values.
      do 20 j = 1, Y_LENGTH
         do 10 i = 1, X_LENGTH
            all_image(1, i, j) = i + j * 10
            all_image(2, i, j) = i + j * 10
10       continue
20    continue

C     Set up the start and edge parameters to write the buffered
C     data to the entire array.
      start(1) = 0
      start(2) = 0
      edges(1) = X_LENGTH
      edges(2) = Y_LENGTH
      stride(1) = 1
      stride(2) = 1

C     Write the buffered data in all_image to the data set array.
      status = mgwrimg(ri_id, start, stride, edges, all_image)

C     Close the GR interface and the file, then re-open both and
C     select the first and only data set in the file.
      status = mgendac(ri_id)
      status = mgend(gr_id)
      status = hclose(file_id)
      file_id = hopen('Example5.hdf', DFACC_RDONLY, 0)
      gr_id = mgstart(file_id)
      ri_id = mgselct(gr_id, 0)

C     Read the data into sample_image, skipping every fourth row
C     and every other column.
      edges(1) = 5
      edges(2) = 5
      stride(1) = 4
      stride(2) = 2

C     Terminate access to the array.
      status = mgendac(ri_id)

C     Terminate access to the GR interface.
      status = mgend(gr_id)

C     Close the file.
      status = hclose(file_id)

      end
