      PROGRAM WRITE ARRAY

      integer*4 ri_id, gr_id, file_id, ncomp, il
      integer dims(2), start(2), edges(2), stride(2)
      integer i, j, status
      integer mgstart, mgcreat, mgwrimg, mgendac, mgend
      integer hopen, hclose
      integer*4 DFACC_CREATE, DFNT_INT16
      integer*4 X_LENGTH, Y_LENGTH
      parameter (DFACC_CREATE = 4, DFNT_INT16 = 22, X_LENGTH = 15,
     +           Y_LENGTH = 10, MFGR_INTERLACE_PIXEL = 0)
      integer*2 image_data(2, X_LENGTH, Y_LENGTH)

C     Create and open the file.
      file_id = hopen('Example2.hdf', DFACC_CREATE, 0)

C     Initiate the GR interface.
      gr_id = mgstart(file_id)

C     Define the number of components and dimensions of the image.
      ncomp = 2
      il = MFGR_INTERLACE_PIXEL
      dims(1) = X_LENGTH
      dims(2) = Y_LENGTH

C     Create the data set.
      ri_id = mgcreat(gr_id, 'Ex_array_2', ncomp, DFNT_INT16, il, dims)

C     Fill the stored-data array with values.
      do 20 j = 1, Y_LENGTH
         do 10 i = 1, X_LENGTH
            image_data(1, i, j) = i + j - 1
            image_data(2, i, j) = i + j - 1
10         continue
20    continue

C     Define the location, pattern, and size of the data set
C     that will be written to.
      start(1) = 0
      start(2) = 0
      edges(1) = X_LENGTH
      edges(2) = Y_LENGTH
      stride(1) = 1
      stride(2) = 1

C     Write the stored data to the image array.
      status = mgwrimg(ri_id, start, stride, edges, image_data)

C     Terminate access to the array.
      status = mgendac(ri_id)

C     Terminate access to the GR interface.
      status = mgend(gr_id)

C     Close the file.
      status = hclose(file_id)

      end
