#include "hdf.h"
#include "mfgr.h"

#define X_LENGTH 20
#define Y_LENGTH 20

main( )
{
	int32 gr_id, ri_id, file_id, pal_id, status, num_entries;
	int32 data_type, ncomp, num_comp, interlace_mode; 
	int32 r_num_entries, r_data_type, r_ncomp, r_interlace_mode; 
	uint8 palette_data[256*3];
	uint8 r_palette_data[256*3];
	intn i, j;
	int32 dims[2];

	/* Create and open the file. */
	file_id = Hopen("Example11.hdf", DFACC_CREATE, 0);

	/* Initiate the GR interface. */
	gr_id = GRstart(file_id);

	/* Define the number of components and dimensions of the image. */
	ncomp = 1;
	dims[0] = X_LENGTH;
	dims[1] = Y_LENGTH;
	interlace_mode = MFGR_INTERLACE_PIXEL;

	/* Create the image. */
	ri_id = GRcreate(gr_id, "Image_12", ncomp, DFNT_UINT8, 
						interlace_mode, dims);

	/* Initialize the palette to grayscale. */
	for (i = 0; i < 256; i++) {
	 	palette_data[i * 3] = i;
	 	palette_data[i * 3 + 1] = i;
	 	palette_data[i * 3 + 2] = i;
	}

	/* Set palette characteristics. */
	data_type = DFNT_UINT8;
	num_entries = 256;
	num_comp = 3;

	/* Get the id for the palette. */
	pal_id = GRgetlutid(ri_id, 0);

	/* Write the palette to file. */
	status = GRwritelut(pal_id, num_comp, data_type, 
							interlace_mode, num_entries, 
						(VOIDP)palette_data);

	/* Read the palette information. */
	status = GRgetlutinfo(pal_id, &r_ncomp, &r_data_type, 
							&r_interlace_mode, &r_num_entries); 

	/* Read the palette data. */
	status = GRreadlut(pal_id, (VOIDP)r_palette_data);

	/* Terminate access to the image. */
	status = GRendaccess(ri_id);

	/* Terminate access to the GR interface. */
	status = GRend(gr_id);

	/* Close the file. */
	status = Hclose(file_id);

}
