#include "hdf.h"

main( ) 
{

	int32 gr_id, ri_id, file_id, status;
	int32 attr_index, data_type, count; 
	char attr_name[MAX_GR_NAME];
	int8 *buffer;

	/* Open the file. */
	file_id = Hopen("Example5.hdf", DFACC_RDONLY, 0);

	/* Initialize the GR interface. */
	gr_id = GRstart(file_id);

	/* Find the file attribute named "File contents". */
	attr_index = GRfindattr(gr_id, "File contents");

	/* Get information about the file attribute. */
	status = GRattrinfo(gr_id, attr_index, attr_name, &data_type, &count);

	/* Allocate a buffer to hold the attribute data. */
	buffer = HDmalloc(count * DFKNTsize(data_type));

	/* Read the attribute data. */
	status = GRgetattr(gr_id, attr_index, buffer);

	/* Free the buffer memory. */
	HDfree(buffer);

	/* Get the identifier for the first image. */
	ri_id = GRselect(gr_id, 0);

	/* Find the data set attribute named "Value range". */
	attr_index = GRfindattr(ri_id, "Value range");

	/* Get information about the image attribute. */
	status = GRattrinfo(ri_id, attr_index, attr_name, &data_type, &count);

	/* Allocate a buffer to hold the attribute data. */
	buffer = HDmalloc(count * DFKNTsize(data_type));

	/* Read the attribute data. */
	status = GRgetattr(ri_id, attr_index, buffer);

	/* Terminate access to the array */
	status = GRendaccess(ri_id);

    /* Terminate access to the GR interface. */
	status = GRend(gr_id);

    /* Close the file */
	status = Hclose(file_id);

}
