#include "hdf.h"

main( )
{

   int32 file_id, an_id, ann_id, ann_idx, i, ann_length;
   int32 n_file_label, n_file_desc, n_data_label, n_data_desc;
   int32 status;
   char *ann_buf;

   /* Open the HDF file for reading. */
   file_id = Hopen("Example6.hdf", DFACC_RDWR, 0);

   /* Initialize the AN interface and obtain an interface id. */
   an_id = ANstart(file_id);

   /* Get the annotation information. */
   status = ANfileinfo(an_id, &n_file_label, &n_file_desc, \
                        &n_data_label, &n_data_desc);

   /* Get the file labels. */
   for (i = 0; i < n_file_label; i++) {
   
      /* Get the identifier for the current file label. */
      ann_id = ANselect(an_id, i, AN_FILE_LABEL);

      /* Get the length of the file label. */
      ann_length = ANannlen(ann_id);

      /* Get the length of the file label. */
      ann_buf = HDmalloc(ann_length * sizeof(char));

      /* Read the file label. */
      status = ANreadann(ann_id, ann_buf, ann_length);
   }

   /* Terminate access to the annotation. */
   status = ANendaccess(ann_id);

   /* Terminate access to the AN interface. */
   status = ANend(an_id);

   /* Close the file. */
   status = Hclose(file_id);

}
