#include "hdf.h"

main( )
{
   intn desc_length = -1, status;
   char desc[50];
   int32 file_id;
   uint16 tag = 0, ref = 0;
   uint32 find_offset, find_length;

   /* Open the file and initialize the searching parameters to 0. */
   file_id = Hopen("Example1.hdf", DFACC_READ, 0);

   /*
   * Start a sequential forward search for the first reference
   * number assigned to a scientific data set.
   */
   while (Hfind(file_id, DFTAG_NDG, DFREF_WILDCARD, &tag, &ref, \
          &find_offset, &find_length, DF_FORWARD) != FAIL) {

   /*
   * After discovering a valid reference number, check for an
   * object description by returning the length of the description.
   * If the inquiry fails, continue searching for the next valid
   * reference number assigned to a scientific data set.
   */
      if ((desc_length = DFANgetdesclen("Example1.hdf", tag, ref)) \
           == FAIL)
         break;

   /* 
   * If a description exists and it will fit in the description buffer,
   * print it.
   */
      if (desc_length != FAIL && desc_length <= 50) {
        status = DFANgetdesc("Example1.hdf", tag, ref, desc, desc_length);
        printf("Description: %s\n", desc);
      }
   }

   /* Close the file. */
   status = Hclose(file_id);

}
