#include "hdf.h"
#include "mfhdf.h"

#define X_LENGTH 5
#define Y_LENGTH 16

main( ) 
{
	int32 sd_id, sds_id, status;
	int32 start[2], edges[2];
	int16 write_data[Y_LENGTH][X_LENGTH], intval;
	intn i, j;

	/*	Open the file. */
	sd_id = SDstart("Example3.hdf", DFACC_RDWR);

	/*	Select the first data set. */
	sds_id = SDselect(sd_id, 0);

    /* Compute and store the values that will be written to the
	   selected array data set. */
	for (j = 0; j < Y_LENGTH; j++)
		for (i = 0; i < X_LENGTH; i++)
			write_data[j][i] = (i + 1) + (j + 1) * 10;

    /* Set up the start and edge parameters to write the buffered
	   data to the entire array data set. */
	start[0] = start[1] = 0;
	edges[0] = Y_LENGTH;
	edges[1] = X_LENGTH;

    /* Write the buffered data to the "Ex_array_3" data set. The fifth 
	   argument must be explicitly cast to a generic pointer to conform 
	   to the HDF API definition of SDwritedata.*/
    status = SDwritedata(sds_id, start, NULL, edges, (VOIDP)write_data);

	/*	Alter a value within this data set. */
	intval = 15;
	start[0] = 10;
	start[1] = 1;
	edges[0] = 1;
	edges[1] = 1;
    status = SDwritedata(sds_id, start, NULL, edges, (VOIDP)&intval);

	/*	Terminate access to the data set. */ 
	status = SDendaccess(sds_id);

	/* Terminate access to the SD interface and close the file. */
	status = SDend(sd_id);

}
