#include "hdf.h"
#include "mfhdf.h"

#define X_LENGTH 5
#define Y_LENGTH 16

main( ) 
{
	int32 sd_id, sds_id, status;
	int32 dims[2], start[2], edges[2], rank;
	int16 array_data[Y_LENGTH][X_LENGTH];
	intn i, j;

	/* Create and open the file and initiate the SD interface. */
	sd_id = SDstart("Example3.hdf", DFACC_CREATE);

	/* Define the rank and dimensions of the data set to be created. */
	rank = 2;
	dims[0] = Y_LENGTH;
	dims[1] = X_LENGTH;

	/* Create the array data set. */
	sds_id = SDcreate(sd_id, "Ex_array_3", DFNT_INT16, rank, dims);

	/* Fill the stored-data array with values. */
	for (j = 0; j < Y_LENGTH; j++) {
		for (i = 0; i < X_LENGTH; i++)
			array_data[j][i] = (i + j) + 1;
    }

	/* Define the location, pattern, and size of the data set */
	for (i = 0; i < rank; i++) {
		start[i] = 0;
		edges[i] = dims[i];
	}

    /* Write the stored data to the "Ex_Array_3" data set. The fifth 
	* argument must be explicitly cast to a generic pointer to conform 
	* to the HDF API definition for SDwritedata. */
	status = SDwritedata(sds_id, start, NULL, edges, (VOIDP)array_data);

	/* Terminate access to the array. */
	status = SDendaccess(sds_id);

	/* Terminate access to the SD interface and close the file. */
	status = SDend(sd_id);

}
