      PROGRAM SET ATTRIBS

      integer*4 sd_id, sds_id, dim_id, status
      integer num_values(2)
      integer sfstart, sfsnatt, sfselect, sfdimid
      integer sfendacc, sfend
      integer DFACC_RDWR, DFNT_CHAR8, DFNT_INT32
      parameter (DFACC_RDWR = 3, DFNT_CHAR8 = 4, DFNT_INT32 = 24)

C     Open the file and get the identifier for the file. 
      sd_id = sfstart('Example4.hdf', DFACC_RDWR)

C     Set an attribute that describes the file contents. 
      status = sfsnatt(sd_id, 'file_contents', DFNT_CHAR8, 16, 
     +                 'storm_track_data')
C     Get the identifier for the first data set. 
      sds_id = sfselect(sd_id, 0)

C     Set an attribute the specifies a valid range of values. 
      num_values(1) = 2
      num_values(2) = 10
      status = sfsnatt(sds_id, 'valid_range', DFNT_INT32, 2, num_values)

C     Get the identifier for the first dimension. 
      dim_id = sfdimid(sds_id, 0)

C     Set an attribute that specifies the dimension metric. 
      status = sfsnatt(dim_id, 'dim_metric', DFNT_CHAR8, 9, 'millibars')

C     Terminate access to the array 
      status = sfendacc(sds_id)

C     Terminate access to the SD interface and close the file 
      status = sfend(sd_id)
      end
