      PROGRAM CONFIRM FILE

      integer*4 sd_id, sds_id, rank, nt, nattrs, status
      integer start(2), edge(2), stride(2)
      integer datavar
      integer sfstart, sfselect, sfiscvar, sfginfo
      integer sfrdata, sfendacc, sfend

C     DFACC_RDONLY is defined in hdf.h. MAX_NC_NAME and MAX_VAR_DIMS
C     are defined in netcdf.h.
      integer*4 DFACC_RDONLY, MAX_NC_NAME, MAX_VAR_DIMS
      integer*4 X_LENGTH, Y_LENGTH
      parameter (DFACC_RDONLY = 1, MAX_NC_NAME = 256, 
     +           MAX_VAR_DIMS = 32, X_LENGTH = 4, Y_LENGTH = 15)
      integer*2 array_data(X_LENGTH, Y_LENGTH)
      character name(MAX_NC_NAME)
      integer dims(MAX_VAR_DIMS)

C     Open the file and initiate the SD interface.
      sd_id = sfstart('Example3.hdf', DFACC_RDONLY)

C     Select the first (and in this case, only) data set in the file.
      sds_id = sfselect(sd_id, 0)

C     Confirm that the data set is not a coordinate variable.
      datavar = sfiscvar(sds_id)
      if (datavar .eq. 0) then

C        Verify the characteristics of the array.
         status = sfginfo(sds_id, name, rank, dims, nt, nattrs)

C        Define the location, pattern, and size of the data to read
C        from the data set.
         start(1) = 0
         start(2) = 0
         stride(1) = 1
         stride(2) = 1
         edge(1) = dims(1)
         edge(2) = dims(2)

C        Read the array data set.
         status = sfrdata(sds_id, start, stride, edge, array_data)
      endif

C     Terminate access to the array data set.
      status = sfendacc(sds_id)

C     Terminate access to the SD interface and close the file.
      status = sfend(sd_id)
      end
