#include "hdf.h"
#include "mfhdf.h"

#define X_LENGTH 5
#define Y_LENGTH 16

main( ) 
{

	int32 sd_id, sds_id, status;
	int32 rank, nt, dims[MAX_VAR_DIMS], nattrs;
	int32 start[2], edges[2];
	int16 array_data[Y_LENGTH][X_LENGTH];
	char name[MAX_NC_NAME];

	/* Open the file and initiate the SD interface. */
	sd_id = SDstart("Example3.hdf", DFACC_RDONLY);

	/* Select the first (and in this case, only) data set in the file. */
	sds_id = SDselect(sd_id, 0);

	/* Confirm that the data set is not a coordinate variable. */
	if (FALSE == SDiscoordvar(sds_id)) {

	/* Verify the characteristics of the array. */
		status = SDgetinfo(sds_id, name, &rank, dims, &nt, &nattrs);

	/* Define the location, pattern, and size of the data to read from \
		the data set. */
		start[0] = start[1] = 0;
		edges[0] = dims[0];
		edges[1] = dims[1];

	/* Read the array data set created in Example 3. */
		status = SDreaddata(sds_id, start, NULL, edges, (VOIDP)array_data);

    }

    /* Terminate access to the array data set. */
		status = SDendaccess(sds_id);

	/* Terminate access to the SD interface and close the file. */
	    status = SDend(sd_id);

}
