      PROGRAM ALTER DIMENSION 

      integer*4 sd_id, sds_id, dim_index, dim_id, status
      integer*4 count, num_attrs
      integer sfstart, sfn2index, sfdimid, sfgdinfo
      integer sfsdscale, sfsdmname, sfendacc
      integer sfend, sfselect, num_type, i, dim_scale(6)
      integer DFACC_RDWR, MAX_NC_NAME, DFNT_INT16
      parameter (DFACC_RDWR = 3, MAX_NC_NAME = 256, DFNT_INT16 = 22)
      character dim_name(MAX_NC_NAME)

C     For each dimension of the 'Ex_array_4' array data set, 
      do 5 i = 1, 6
         dim_scale(i) = i
5     continue

C     Open the file. 
      sd_id = sfstart('Example4.hdf', DFACC_RDWR)

C     Get the index of the 'Ex_array_4' array data set. 
      sds_index = sfn2index(sd_id, 'Ex_array_4')

C     Select the data set corresponding to the returned index.
      sds_id = sfselect(sd_id, sds_index)

C     For each dimension of the 'Ex_array_4' array data set, 
      do 10 dim_index = 1, 3

C      - select the dimension id, 
         dim_id = sfdimid(sds_id, dim_index-1)

C      - get the information about the selected dimension, 
         status = sfgdinfo(dim_id, dim_name, count, num_type, num_attrs)

C      - alter the dimension names. 
         if (dim_index .eq. 1) then
         status = sfsdmname(dim_id, 'Z_Axis') 
         end if
         if (dim_index .eq. 2) then
         status = sfsdmname(dim_id, 'Y_Axis') 
         end if
         if (dim_index .eq. 3) then
         status = sfsdmname(dim_id, 'X_Axis') 
         end if

         num_type = DFNT_INT16

C     - and, alter the dimension scale, write it to the data set, 
         dim_scale(1) = 3
         dim_scale(2) = 2
         dim_scale(3) = 1
         dim_scale(4) = 0
         dim_scale(5) = -1
         dim_scale(6) = -2
         status = sfsdscale(dim_id, count, num_type, dim_scale)
10    continue

C     Terminate access to the array.
      status = sfendacc(sds_id)

C     Terminate access to the SD interface and close the file.
      status = sfend(sd_id)
      end
