#include "hdf.h"
#include "mfhdf.h"

main( ) 
{
	int32 sd_id, sds_id, dim_index, dim_id, sds_index, status;
	int32 count, num_type, num_attrs;
	int16 dim_scale[] = {6,5,4,3,2,1};
    char dim_name[MAX_NC_NAME];

	/* Open the file. */
	sd_id = SDstart("Example4.hdf", DFACC_RDWR);

	/* Get the index of the "Ex_array_4" array data set. */
	sds_index = SDnametoindex(sd_id, "Ex_array_4");

	/* Select the data set corresponding to the returned index. */
	sds_id = SDselect(sd_id, sds_index);

	/* For each dimension of the "Ex_array_4" array data set, */
	for (dim_index = 0; dim_index < 3; dim_index++) {

	/* - select the dimension id, */
		dim_id = SDgetdimid(sds_id, dim_index);

	/* - get the information about the selected dimension, */
		status = SDdiminfo(dim_id, dim_name, &count, &num_type, \
	                       &num_attrs);
		num_type = DFNT_INT16;

	/* - alter the dimension names, */
		switch(dim_index) {
			case 0:		SDsetdimname(dim_id, "Z_Axis"); 
					break;
			case 1:		SDsetdimname(dim_id, "Y_Axis"); 
	 				break;
			case 2:		SDsetdimname(dim_id, "X_Axis"); 
					break;
			default:		break;
		}

	/* - then alter the dimension scale and write it to the data set. */
		dim_scale[0] = 3;
		dim_scale[1] = 2;
		dim_scale[2] = 1;
		status = SDsetdimscale(dim_id, count, num_type, (VOIDP)dim_scale);
	
    }

	/* Terminate access to the array */
	status = SDendaccess(sds_id);

	/* Terminate access to the SD interface and close the file */
	status = SDend(sd_id);

}
