      PROGRAM PRINT NAMES

      integer*4 sd_id, sds_id
      integer*4 n_datasets, n_file_attrs, index
      integer status, attributes
      integer sfstart, sffinfo, sfselect, sfginfo
      integer sfendacc, sfend

C     DFACC_RDONLY is defined in hdf.h. MAX_NC_NAME and MAX_VAR_DIMS
C     are defined in netcdf.h.
      integer*4 DFACC_RDONLY, MAX_NC_NAME, MAX_VAR_DIMS
      parameter (DFACC_RDONLY = 1, MAX_NC_NAME = 256,
     +            MAX_VAR_DIMS = 32)

      integer*4 dim_sizes(MAX_VAR_DIMS)
      character name *(MAX_NC_NAME)

C     Open the file and initiate the SD interface.
      sd_id = sfstart('Example4.hdf', DFACC_RDONLY)

C     Determine the contents of the file.
      status = sffinfo(sd_id, n_datasets, n_file_attrs)

C     Access and print the names of every data set in the file.
      do 10 index = 0, n_datasets - 1
         sds_id = sfselect(sd_id, index)
         status = sfginfo(sds_id, name, rank, dim_sizes, num_type, 
     +                    attributes)
         print *, "name = ", name
         status = sfendacc(sds_id)
10    continue

C     Terminate access to the SD interface and close the file.
      status = sfend(sd_id)

      end
