      PROGRAM READ STRIDES

      integer*4 sd_id, sds_id, rank
      integer*4 start(2), edges(2), stride(2), dims(2)
      integer i, j, status
      integer sfstart, sfcreate, sfwdata, sfrdata, sfendacc
      integer sfselect, sfend

C     DFACC_CREATE and DFNT_INT16 are defined in hdf.h.
      integer*4 DFACC_CREATE, DFACC_RDONLY, DFNT_INT16
      integer*4 X_LENGTH, Y_LENGTH
      parameter (DFACC_CREATE = 4, DFACC_RDONLY = 1, DFNT_INT16 = 22,
     +            X_LENGTH = 10, Y_LENGTH = 20)
      integer*2 all_data(X_LENGTH, Y_LENGTH), sample_data(5, 5)

C     Create the file. 
      sd_id = sfstart('Example10.hdf', DFACC_CREATE)

C     Define the rank and dimensions of the array to be created. 
      rank = 2
      dims(1) = X_LENGTH
      dims(2) = Y_LENGTH

C     Create the array. 
      sds_id = sfcreate(sd_id, 'Ex_array_10', DFNT_INT16, rank, dims)

C     Compute and store the data values. 
      do 20 j = 1, Y_LENGTH
         do 10 i = 1, X_LENGTH
            all_data(i, j) = i + j * 10
10         continue
20    continue

C     Set up the start and edge parameters to write the buffered
C     data to the entire array data set. 
      start(1) = 0
      start(2) = 0
      edges(1) = X_LENGTH
      edges(2) = Y_LENGTH
      stride(1) = 1
      stride(2) = 1

C     Write the buffered data in wrt_data to the data set. 
      status = sfwdata(sds_id, start, stride, edges, all_data)

C     Close the SD interface and the file, then re-open both and 
C     select the first and only data set in the file. 
      status = sfendacc(sds_id)
      status = sfend(sd_id)
      sd_id = sfstart('Example10.hdf', DFACC_RDONLY)
      sds_id = sfselect(sd_id, 0)

C     Read the data into the sample_data array, skipping every fourth row 
C     and every other column. 
      edges(1) = 5
      edges(2) = 5
      stride(1) = 2
      stride(2) = 4
      status = sfrdata(sds_id, start, stride, edges, sample_data)

C     Terminate access to the array. 
      status = sfendacc(sds_id)

C     Terminate access to the SD interface and close the file. 
      status = sfend(sd_id)

      end
