#include "hdf.h"

main( ) 
{
	int32 gr_id, ri_id, file_id, dim_index, status;
	int32 num_values[2];

	/* Open the file. */
	file_id = Hopen("Example5.hdf", DFACC_RDWR, 0);

	/* Initialize the GR interface. */
	gr_id = GRstart(file_id);

	/* Set an attribute that describes the file contents. */
	status = GRsetattr(gr_id, "File contents", DFNT_CHAR8, 16, \
					(VOIDP)"RGB image data");

	/* Get the identifier for the first data set. */
	ri_id = GRselect(gr_id, 0);

	/* Set an attribute the specifies a valid range of values. */
	num_values[0] = 2;
	num_values[1] = 10;
	status = GRsetattr(ri_id, "Value range", DFNT_INT32, 2, \
						(VOIDP)num_values);

	/* Terminate access to the image. */
	status = GRendaccess(ri_id);

	/* Terminate access to the GR interface. */
	status = GRend(gr_id);

	/* Close the file. */
	status = Hclose(file_id);

}
