#include "hdf.h"

#define X_LENGTH 10
#define Y_LENGTH 20

main( ) 
{

	int32 gr_id, gr_index, ri_id, file_id, status;
	int32 start[2], edges[2]; 
	int16 image_data[Y_LENGTH][X_LENGTH][2];

	/* Open the file. */
	file_id = Hopen("Example5.hdf", DFACC_RDONLY, 0);

	/* Initiate the GR interface. */
	gr_id = GRstart(file_id);

	/* Search for the index of a non-existent image. */
	gr_index = GRnametoindex(gr_id, "Invalid_Data_Set_Name");

	/* Error condition: gr_index contains the value -1. */

	/* Search for the index of the image named "Image_array_5". */
	gr_index = GRnametoindex(gr_id, "Image_array_5");

    /* Select the image corresponding to the returned index. */
    ri_id = GRselect(gr_id, gr_index);

    /* Read the data set data into the array_data array. */
	start[0] = start[1] = 0;
	edges[0] = X_LENGTH;
	edges[1] = Y_LENGTH;
	status = GRreadimage(ri_id, start, NULL, edges, (VOIDP)image_data);

	/* Terminate access to the array */
    status = GRendaccess(ri_id);

    /* Terminate access to the GR interface. */
    status = GRend(gr_id);

    /* Close the file */
    status = Hclose(file_id);

}
