#include "hdf.h"
#include "mfgr.h"

#define X_LENGTH 10
#define Y_LENGTH 20

main( ) 
{
	int32 gr_id, ri_id, file_id, start[2], edges[2], ncomp, il;
    int32 stride[2], dims[2];
	int16 all_image[Y_LENGTH][X_LENGTH][2], sample_image[5][5][2], status;
	intn i, j;

	/* Open the file. */
	file_id = Hopen("Example5.hdf", DFACC_CREATE, 0);

	/* Open the file. */
	gr_id = GRstart(file_id);

	/* Define the number of components and dimensions of the image. */
	ncomp = 2;
	dims[0] = X_LENGTH;
	dims[1] = Y_LENGTH;
    il = MFGR_INTERLACE_PIXEL;

	/* 	Create the array. */
	ri_id = GRcreate(gr_id, "Image_array_5", ncomp, DFNT_INT16, il, dims);

	/* 	Compute and store the data values. */
	for (j = 0; j < Y_LENGTH; j++) {
		for (i = 0; i < X_LENGTH; i++) {
			all_image[j][i][0] = i + j * 10;
			all_image[j][i][1] = i + j * 10;
		}
    }
	/* 	Define the start and edge parameters. */
	start[0] = start[1] = 0;
	edges[0] = X_LENGTH;
	edges[1] = Y_LENGTH;

	/* 	Write the buffered data in all_image to the array. */
	status = GRwriteimage(ri_id, start, NULL, edges, (VOIDP)all_image);

	/* 	Close the GR interface and the file, then re-open both and 
		select the first and only data set in the file. */
	status = GRendaccess(ri_id);
	status = GRend(gr_id);
	status = Hclose(file_id);
	file_id = Hopen("Example5.hdf", DFACC_RDONLY, 0);
	gr_id = GRstart(file_id);
	ri_id = GRselect(gr_id, 0);

	/* 	Read the data into sample_image, skipping every fourth \
		row and every other column. */
	start[0] = start[1] = 0;
	edges[0] = 5;
	edges[1] = 5;
	stride[0] = 2;
	stride[1] = 4;
	status = GRreadimage(ri_id, start, stride, edges, (VOIDP)sample_image);

	/* 	Terminate access to the array */
	status = GRendaccess(ri_id);

	/* 	Terminate access to the GR interface the file */
	status = GRend(gr_id);

	/* 	Close the file */
	status = Hclose(file_id);

}
