#include "hdf.h"

#define X_LENGTH 15
#define Y_LENGTH 10

main( )
{
    int32 gr_id, ri_id, file_id, status;
    int32 start[2], edges[2], dims[2], nattrs;
    int16 image_data[Y_LENGTH][X_LENGTH][2];

    /* Open the file. */
    file_id = Hopen("Example2.hdf", DFACC_RDONLY, 0);

    /* Open the file and initiate the GR interface. */
    gr_id = GRstart(file_id);

    /* Select the first (and in this case, only) data set in the file. */
    ri_id = GRselect(gr_id, 0);

    /* Define the location, pattern, and size of the data to read. */
    dims[0] = X_LENGTH;
    dims[1] = Y_LENGTH;
    start[0] = start[1] = 0;
    edges[0] = dims[0];
    edges[1] = dims[1];

	/* Read the data in the image array. */
    status = GRreadimage(ri_id, start, NULL, edges, (VOIDP)image_data);

	/* Terminate access to the image array */
    status = GRendaccess(ri_id);

	/* Terminate access to the GR interface. */
    status = GRend(gr_id);

	/* Close the file. */
    status = Hclose(file_id);

}
