#include "hdf.h"
#include "mfgr.h"

#define X_LENGTH 15
#define Y_LENGTH 10

main( ) 
{
	int32 gr_id, ri_id, file_id, status;
	int32 dims[2], start[2], edges[2], ncomp, il;
	int16 image_data[Y_LENGTH][X_LENGTH][2], i, j;

	/* Create and open the file. */
	file_id = Hopen("Example2.hdf", DFACC_CREATE, 0);

	/* Initiate the GR interface. */
	gr_id = GRstart(file_id);

	/* Define the number of components and dimensions of the image. */
	ncomp = 2;
	il = MFGR_INTERLACE_PIXEL;
	dims[0] = X_LENGTH;
	dims[1] = Y_LENGTH;

	/* Create the array. */
	ri_id = GRcreate(gr_id, "Ex_array_2", ncomp, DFNT_INT16, il, dims);

	/* Fill the stored-data array with values. */
	for (j = 0; j < Y_LENGTH; j++) {
		for (i = 0; i < X_LENGTH; i++) {
			image_data[j][i][0] = (i + j) + 1;
			image_data[j][i][1] = (i + j) + 1;
		}
    }

	/* Define the location, pattern, and size of the data set */
	for (i = 0; i < 2; i++) {
		start[i] = 0;
		edges[i] = dims[i];
	}

    /* Write the stored data to the image array. */
	status = GRwriteimage(ri_id, start, NULL, edges, (VOIDP)image_data);

	/* Terminate access to the array. */
	status = GRendaccess(ri_id);

	/* Terminate access to the GR interface. */
	status = GRend(gr_id);

	/* Close the file. */
	status = Hclose(file_id);

}

