      PROGRAM READ WRITE PALETTE

      integer*4 gr_id, ri_id, file_id, pal_id, status
      integer*4 num_entries, data_type, ncomp, interlace_mode
      integer*4 r_interlace_mode, r_num_entries, r_data_type
      integer*4 r_ncomp, ncomp, num_comp, dims(2)
      character palette_data(256*3)
      character r_palette_data(256*3)
      integer i
      integer*4 MFGR_INTERLACE_PIXEL, DFNT_CHAR8, X_LENGTH
      integer*4 Y_LENGTH
      parameter(MFGR_INTERLACE_PIXEL = 0, DFNT_CHAR8 = 4,
     +          X_LENGTH = 20, Y_LENGTH = 20)
      integer hopen, hclose, mgstart, mgcreat, mgwrlut
      integer mggltid, mgglinf, mgrdlut, mgendac, mgend

C     Create and open the file.
      file_id = hopen('Example11.hdf', DFACC_CREATE, 0)

C     Initiate the GR interface.
      gr_id = mgstart(file_id)

C     Define the Number of components and dimensions of the image
C     and palette to be created.
      ncomp = 1
      num_entries = 256
      num_comp = 3
      dims(1) = X_LENGTH
      dims(2) = Y_LENGTH
      interlace_mode = MFGR_INTERLACE_PIXEL
      data_type = DFNT_CHAR8

C     Create the image.
      ri_id = mgcreat(gr_id, 'Image_12', ncomp, data_type,
     +                interlace_mode, dims)

C     Initialize the palette to greyscale.
      do 10, i = 1, 256
        palette_data((i - 1) * 3 + 1) = char(i - 1)
        palette_data((i - 1) * 3 + 2) = char(i - 1)
        palette_data((i - 1) * 3 + 3) = char(i - 1)
10    continue

C     Get the identifier for the palette.
      pal_id = mggltid(ri_id, 0)

C     Write the palette to the HDF file.
      status = mgwrlut(pal_id, num_comp, data_type,
     +                 interlace_mode, num_entries,
     +                 palette_data)

C     Read the palette information.
      status = mgglinf(pal_id, ncomp, data_type,
     +                 interlace_mode, num_entries)

C     Read the palette data.
      status = mgrdlut(pal_id, r_ncomp, r_data_type,
     +                 r_interlace_mode, r_num_entries,
     +                 r_palette_data)

C     Terminate access to the image.
      status = mgendac(ri_id)

C     Terminate access to the GR interface.
      status = mgend(gr_id)

C     Close the file.
      status = hclose(file_id)

      end
