      PROGRAM VGROUP INSERT

      integer file_id, vgroup_id, status, tag, ref
      integer*4 raster_data(6, 5) 
      integer i, j, k
      integer hopen, vfatch, vfsnam, vfscls
      integer d8aimg, d8lref, vfadtr, vfdtch, vfatch
      integer hclose, vfstart, vfend
      integer DFACC_CREAT
      parameter (DFACC_CREAT = 4)

C     Construct the data image to be written to the vgroup.
      do 20 j = 1, 5
        do 10 i = 1, 6
            raster_data(i, j) = k
            k = k + 1
10      continue
20    continue

C     Open an HDF file with full access.
C     DFACC_CREAT is defined in hdf.inc.
      file_id = hopen('Example1.hdf', DFACC_CREAT, 0)

C     Open a vgroup with write access. 
      status = vfstart(file_id)
      vgroup_id = vfatch(file_id, -1, 'w') 

C     Set the name and class for this vgroup. 
      status = vfsnam(vgroup_id, 'VG_Name_1')
      status = vfscls(vgroup_id, 'VG_Class_1')

C     Write the data to file and determine its tag and reference 
C     number. 
      status = d8aimg('Example1.hdf', raster_data, 6, 5, 0)
      ref = d8lref( )

C     The number '202' corresponds to the value of DFTAG_RI8 in 
C     hdf.inc.
      tag = 202

C     Insert the data image into the vgroup. 
      status = vfadtr(vgroup_id, tag, ref)

C     Terminate access to the V interface. 
      status = vfdtch(vgroup_id)
      status = vfend(file_id)

C     Close the HDF file. 
      status = hclose(file_id)

      end
