#include "hdf.h"
#include "vg.h"

#define FILE_NAME "Example3.hdf"
#define VATTR_NAME "Vdata Attribute 1"
#define FATTR_NAME "Field Attribute 1"

main( )
{

	int32	file_id, vdata_ref, vdata_id, status;
	int32	n_vdattrs, n_fldattrs;
	int32		v_type, v_count, v_size, f_type, f_count, f_size;
	char		vd_attr[6] = {'m','N','p', 'S', 't', '\0'};
	char		vattr_buf[6];
	char		vattrname[30], fattrname[30];
	float32 	fld_attr[2] = {30.452, 5.467};
	float32		fattr_buf[2];
	
	/* Open the HDF file. */
	file_id = Hopen(FILE_NAME, DFACC_RDWR, 0);

	/* Initialize the vdata interface. */
	status = Vstart(file_id);

    /* Get the reference number of the target vdata. */
    vdata_ref = VSfind(file_id, "Example Vdata");

    /* Attach to the target vdata. */
    vdata_id = VSattach(file_id, vdata_ref, "w");

    /* Attach an attribute to the vdata. */
    status = VSsetattr(vdata_id, _HDF_VDATA, VATTR_NAME, DFNT_CHAR,\
						6, vd_attr);

    /* Attach an attribute to the first field in the vdata. */
    status = VSsetattr(vdata_id, 0, FATTR_NAME, DFNT_FLOAT32, 2, fld_attr);

	/* Get the number of attributes attached to the first field - \
		should be 1. */
    n_fldattrs = VSfnattrs(vdata_id, 0);

	/* Get the total number of field and vdata attributes. \
		This should be 2. */
    n_vdattrs = VSnattrs(vdata_id);

    /* Get information about the vdata attribute. */
    status = VSattrinfo(vdata_id, _HDF_VDATA, 0, vattrname, \
    			&v_type, &v_count, &v_size);

    /* Get information about the field attribute. */
    status = VSattrinfo(vdata_id, 0, 0, fattrname, &f_type, &f_count, &f_size);

    /* Get the vdata attribute. */
    status = VSgetattr(vdata_id, _HDF_VDATA, 0, vattr_buf);

    /* Get the field attribute. */
    status = VSgetattr(vdata_id, 0, 0, fattr_buf);

	/* Detach from the vdata, close the VS interface and the file. */
	status = VSdetach(vdata_id);
	status = Vend(file_id);
	status = Hclose(file_id);

}


