      PROGRAM DATA PACK

      integer hopen, vsfatch, vsffdef, vsfsnam
      integer vsfscls, vsfsfld, vsfwrit, vsfdtch
      integer hclose, vfstart

C     Parameter definitions
      integer*4 DFACC_CREATE, DFNT_FLOAT32, DFNT_INT16, DFNT_CHAR8
      integer*4 FULL_INTERLACE
      parameter (DFACC_CREATE = 4,
     +           DFNT_FLOAT32 = 5,
     +           DFNT_INT16 = 22,
     +           DFNT_CHAR8 = 4,
     +           FULL_INTERLACE = 0)

C     Example parameters.
      integer NRECORDS
      parameter (NRECORDS = 20)

C     Vdata fields.
      real temp
      integer*2 height
      real speed

C     Vdata field equivalence names for packing. 
      character ctemp*4
      character cheight*2
      character cspeed*4
      equivalence (temp, ctemp), (height, cheight), (speed, cspeed)

C     Packing buffer with size (4+2+4+1)*NRECORDS = 220.
      character buffer*220

C     More local variables.
      integer i, bufptr, status
      integer*4 file_id, vdata_id
      character*20 idents /"ABCDEFGHIJKLMNOPQRST"/

C     Create the file. 
      file_id = hopen('Example4.hdf', DFACC_CREATE, 0)

C     Initialize the interface. 
      status = vfstart(file_id)

C     Create a new vdata. 
      vdata_id = vsfatch(file_id, -1, 'w')

C     Define the fields to write. 
      status = vsffdef(vdata_id, 'Temp', DFNT_FLOAT32, 1) 
      status = vsffdef(vdata_id, 'Height', DFNT_INT16, 1) 
      status = vsffdef(vdata_id, 'Speed', DFNT_FLOAT32, 1) 
      status = vsffdef(vdata_id, 'Ident', DFNT_CHAR8, 1) 

C     Set the vdata name. 
      status = vsfsnam(vdata_id, 'Example Vset Name')

C     Set the vdata class. 
      status = vsfscls(vdata_id, 'Example Vset Class')

C     Set the field names. 
      status = vsfsfld(vdata_id, 'Temp,Height,Speed,Ident')

C     Pack NRECORDS of data into buffer.
      bufptr = 1

      do 10 i = 1, NRECORDS
C       Pack temp data. 
        temp = 1.1 * i
        buffer(bufptr:bufptr+3) = ctemp
        bufptr = bufptr + 4

C       Pack height data.
        height = i 
        buffer(bufptr:bufptr+1) = cheight
        bufptr = bufptr + 2

C       Pack speed data.
        speed = 11.1 * i
        buffer(bufptr:bufptr+3) = cspeed
        bufptr = bufptr + 4

C       Pack ident data.
        buffer(bufptr:bufptr) = idents(i:i)
        bufptr = bufptr + 1
10    continue

      status = vsfwrit(vdata_id, buffer, NRECORDS, FULL_INTERLACE)

C     Terminate access to the vdata object, the interface 
C     and the file.
      status = vsfdtch(vdata_id)
      status = vfend(file_id)
      status = hclose(file_id)

      end

