#include <stdio.h>
#include "hdf.h"

#define NRECORDS 20

#define FIELD_1 "Temp" 
#define FIELD_2 "Height" 
#define FIELD_3 "Speed" 
#define FIELD_4 "Ident"
#define FIELD_NAMES "Temp,Height,Speed,Ident"

main( ) 
{

	struct {
	   float32 	temp;
	   int16 	height;
	   float32 	speed;
	   char	ident;
	} source[NRECORDS];

	int32	file_id, vdata_id;
	uint8	*pntr;
	uchar8	*databuf;
	int	i;
	int32	status;
	int32	msize = 0;

	/* Create the HDF file. */
	file_id = Hopen("Example4.hdf", DFACC_CREATE, 0);

	/* Initialize the Vset interface. */
	status = Vstart(file_id);

	/* Create a new vdata. */
	vdata_id = VSattach(file_id, -1, "w");

	/* Define the field to write. */
	status = VSfdefine(vdata_id, FIELD_1, DFNT_FLOAT32, 1); 
	status = VSfdefine(vdata_id, FIELD_2, DFNT_INT16, 1); 
	status = VSfdefine(vdata_id, FIELD_3, DFNT_FLOAT32, 1); 
	status = VSfdefine(vdata_id, FIELD_4, DFNT_CHAR8, 1); 

	/* Set the vdata name. */
	status = VSsetname(vdata_id, "Example Vset Name");

	/* Set the vdata class. */
	status = VSsetclass(vdata_id, "Example Vset Class");

	/* Set the field names. */
	status = VSsetfields(vdata_id, FIELD_NAMES);

	databuf = (uint8 *) malloc(((2 * sizeof(float32)) 
	           + sizeof(int16) + sizeof(char)) * NRECORDS);

	pntr = databuf;

	for (i = 0; i < NRECORDS; i++) {
	   source[i].temp = 1.11 * (i+1);
	   memcpy(pntr, &source[i].temp, sizeof(float32)); 
	   pntr += sizeof(float32);

	   source[i].height = i+1;
	   memcpy(pntr, &source[i].height, sizeof(int16)); 
	   pntr += sizeof(int16);

	   source[i].speed = 1.11 * (i+1);
	   memcpy(pntr, &source[i].speed, sizeof(float32)); 
	   pntr += sizeof(float32);

	   source[i].ident = 'A'+i;
	   memcpy(pntr, &source[i].ident, sizeof(char)); 
	   pntr += sizeof(char);
	}

	/* Write the data to the Vset object. */
    status = VSwrite(vdata_id, databuf, NRECORDS, FULL_INTERLACE); 

	/* 
	* Terminate access to the vdata, the VS interface 
	* and the HDF file.
	*/
	status = VSdetach(vdata_id);
	status = Vend(file_id);
	status = Hclose(file_id);

}
