      PROGRAM VSET CREATE

      integer*4 file_id, vdata_ref1, vdata_ref2
      integer vset_data1(5), vset_data2(6, 4), i
      integer hopen, vhfsd, vhfsdm, hclose

C     DFACC_CREATE is defined in 'hdf.inc'. DFNT_INT32 is
C     defined in 'hntdefs.h'.
      integer DFACC_CREATE, DFNT_INT32
      parameter (DFACC_CREATE = 4, DFNT_INT32 = 24)

C     Generate the vset_data1 data. 
      do 10 i = 1, 5
        vset_data1(i) = i
10    continue

C     Generate the vset_data2 data. 
      do 20 i = 1, 6
        do 30 j = 1, 4
          vset_data2(i, j) = i + j
30      continue
20    continue

C     Create the HDF file. 
      file_id = hopen('Example2.hdf', DFACC_CREATE, 0)

C     Initialize the VS interface. 
      status = vfstart(file_id)

C     Create the first vdata and populate it with data
C     from the vset1_data array. 
      vdata_ref1 = vhfsd(file_id, 'Vset1 data', vset_data1,
     +               5, DFNT_INT32, 'First Vset', '5x1 array')

C     Create the second vdata and populate it with data
C     from the vset2_data array. 
      vdata_ref2 = vhfsdm(file_id, 'Vset2 data', vset_data2,
     +               6, DFNT_INT32, 'Second Vset', '6x4 array', 4)

C     Terminate access to the VS interface. 
      status = vfend(file_id)

C     Close the HDF file. 
      status = hclose(file_id)

      end
