      PROGRAM CONFIRM ARRAY

      integer*4 sd_id, sds_id, status
      integer start(3), edge(3), stride(3)
      integer sfstart, sfselect, sfrdata, sfendacc, sfend

C     DFACC_RDONLY is defined in hdf.h. MAX_NC_NAME and MAX_VAR_DIMS
C     are defined in netcdf.h.
      integer*4 DFACC_RDONLY, MAX_NC_NAME, MAX_VAR_DIMS
      integer*4 X_LENGTH, Y_LENGTH, Z_LENGTH
      parameter (DFACC_RDONLY = 1, MAX_NC_NAME = 256, 
     +           MAX_VAR_DIMS = 32, X_LENGTH = 4, 
     +           Y_LENGTH = 5, Z_LENGTH = 6)
      integer*2 array_data(X_LENGTH, Y_LENGTH, Z_LENGTH)
      integer dims(MAX_VAR_DIMS)

C     Open the file and initiate the SD interface.
      sd_id = sfstart('Example4.hdf', DFACC_RDONLY)

C     Select the first (and in this case, only) data set in the file.
      sds_id = sfselect(sd_id, 0)

C     Define the location, pattern, and size of the data to read
C     from the data set.
      dims(1) = X_LENGTH
      dims(2) = Y_LENGTH
      dims(3) = Z_LENGTH
      start(1) = 0
      start(2) = 0
      start(3) = 0
      stride(1) = 1
      stride(2) = 1
      stride(3) = 1
      edge(1) = dims(1)
      edge(2) = dims(2)
      edge(3) = dims(3)

C     Read the array data set.
      status = sfrdata(sds_id, start, stride, edge, array_data)

C     Terminate access to the array data set.
      status = sfendacc(sds_id)

C     Terminate access to the SD interface and close the file.
      status = sfend(sd_id)

      end
