#include "hdf.h"
#include "mfhdf.h"

#define X_LENGTH 10
#define Y_LENGTH 10

main( ) 
{

	int32 sd_id, sds_id, sds_idx;
	int32 dims[2], rank;
	int16 array_data[Y_LENGTH][X_LENGTH], append_data[X_LENGTH];
	int32 start[2], edges[2];
	intn i = 0, j, status;

	/* Open the file and initiate the SD interface. */
	sd_id = SDstart("Example3.hdf", DFACC_RDWR);

    /* Define the rank and dimensions of the array. Make the first \
	   array dimension appendable by defining it's length to be \
	   unlimited.*/
	rank = 2;
	dims[0] = SD_UNLIMITED;
	dims[1] = X_LENGTH;

	/* Create the array data set. */
	sds_id = SDcreate(sd_id, "Ex_File_6", DFNT_INT16, rank, dims);

	/* Store the array values. */
	for (j = 0; j < Y_LENGTH; j++) {
		for (i = 0; i < X_LENGTH; i++)
			array_data[j][i] = (i + 1) + (j + 1);
    }

	/* Write the data to the array. */
	start[0] = start[1] = 0;
	edges[0] = Y_LENGTH;
	edges[1] = X_LENGTH;

	/* Perform the initial write to the array data set. */
	status = SDwritedata(sds_id, start, NULL, edges, (VOIDP)array_data);

    /* Terminate access to the array data set, terminate access \
		to the SD interface and close the file. */
    status = SDendaccess(sds_id);
	status = SDend(sd_id);

    /* Reopen the file and initiate the SD interface in preparation 
		for appending data to the data set. Then select the first 
		data set.*/
	sd_id = SDstart("Example3.hdf", DFACC_RDWR);
    sds_idx = SDnametoindex(sd_id, "Ex_File_6");
    sds_id = SDselect(sd_id, sds_idx);

    /* Store the array values to be appended to the data set. */
    for (i = 0; i < X_LENGTH; i++)
		append_data[i] = i + 1;

	/* 	Define the location of the append to start at the first column \
		of the sixteenth row of the data set and to stop at the end of the \
		fifth row. */
    start[0] = Y_LENGTH;
    start[1] = 0;
    edges[0] = 1;
    edges[1] = X_LENGTH;

	/* Append the stored data to the array data set. */
	status = SDwritedata(sds_id, start, NULL, edges, (VOIDP)append_data);

	/* Terminate access to the array data set. */
	status = SDendaccess(sds_id);

	/* Terminate access to the SD interface and close the file. */
	status = SDend(sd_id);

}
