#include "hdf.h"
#include "mfhdf.h"

#define X_LENGTH 4
#define Y_LENGTH 5
#define Z_LENGTH 6

main( ) 
{
	int32 sd_id, sds_id, rank, status;
	int32 dims[3], start[3], edges[3];
	int16 write_data[Z_LENGTH][Y_LENGTH][X_LENGTH];
    int16 zx_data[Z_LENGTH][X_LENGTH];
	intn i, j, k;

    /* Open the file. */
	sd_id = SDstart("Example4.hdf", DFACC_CREATE);

    /* Define the rank and dimensions of the array to be created. */
    rank = 3;
    dims[0] = Z_LENGTH;
    dims[1] = Y_LENGTH;
    dims[2] = X_LENGTH;

    /* Create the array. */
    sds_id = SDcreate(sd_id, "Ex_array_4", DFNT_INT16, rank, dims);

    /* Compute and store the values that will be written to the data 
	   set. Fill the write_data array along the x-axis first. */
	for (k = 0; k < Z_LENGTH; k++)
		for (j = 0; j < Y_LENGTH; j++)
			for (i = 0; i < X_LENGTH; i++)
				write_data[k][j][i] = (i + 1) + (j + 1) + (k + 1);

    /* Within each for loop, set the start and edge parameters to write \ 
		a 4-by-6 element slab of stored data from the write_data array to \ 
		the data set. */
    edges[0] = Z_LENGTH;
    edges[1] = 1;
    edges[2] = X_LENGTH;
    start[0] = start[2] = 0;

    for (j = Y_LENGTH; j > 0; j--) {
    		start[1] = j - 1;
    		for ( k = 0; k < Z_LENGTH; k++) {
    			for ( i = 0; i < X_LENGTH; i++) {
    				zx_data[k][i] = write_data[k][j-1][i];
    				status = SDwritedata(sds_id, start, NULL, edges,
    							         (VOIDP)zx_data);
                }
            }
    }

    /* Terminate access to the data set. */ 
    status = SDendaccess(sds_id);
    
    /* Terminate access to the SD interface and close the file. */
    status = SDend(sd_id);
    
}
