#include "hdf.h"
#include "mfhdf.h"

main( ) 
{

	int32 sd_id, sds_id, dim_id, dim_index, status;
	int32 num_values[2];

	/* Open the file and get the identifier for the file. */
	sd_id = SDstart("Example4.hdf", DFACC_RDWR);

	/* Set an attribute that describes the file contents. */
	status = SDsetattr(sd_id, "file_contents", DFNT_CHAR8, 16, \
					(VOIDP)"storm_track_data");

	/* Get the identifier for the first data set. */
	sds_id = SDselect(sd_id, 0);

	/* Set an attribute the specifies a valid range of values. */
	num_values[0] = 2;
	num_values[1] = 10;
	status = SDsetattr(sds_id, "valid_range", DFNT_INT32, 2, \
						(VOIDP)num_values);

	/* Get the identifier for the first dimension. */
	dim_id = SDgetdimid(sds_id, 0);

	/* Set an attribute that specifies the dimension metric. */
	status = SDsetattr(dim_id, "dim_metric", DFNT_CHAR8, 9, 
					(VOIDP)"millibars");

	/* Terminate access to the array */
	status = SDendaccess(sds_id);

	/* Terminate access to the SD interface and close the file */
	status = SDend(sd_id);

}
